/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.search.searchfield.java;

import au.com.ordermate.gui.renderer.JCheckBoxCellRenderer;
import au.com.ordermate.oquery.search.filter.QuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.search.searchfield.java.AbstractComboSearchField;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.text.Format;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ListCellRenderer;
import javax.swing.text.JTextComponent;

public class MultiSelectComboSearchField
extends AbstractComboSearchField
implements ListEventListener {
    protected JCheckBoxCellRenderer renderer;
    private final MultiOptionSearchFilter searchFilter;

    public MultiSelectComboSearchField(String searchFieldLabel, MultiOptionSearchFilter searchFilter, Action refreshAction, EventList dataList) {
        this(searchFieldLabel, refreshAction, dataList, null, searchFilter, null);
    }

    public MultiSelectComboSearchField(String searchFieldLabel, Action refreshAction, EventList dataList, Format formatter, MultiOptionSearchFilter searchFilter) {
        this(searchFieldLabel, refreshAction, dataList, formatter, searchFilter, null);
    }

    public MultiSelectComboSearchField(String searchFieldLabel, Action refreshAction, EventList dataList, Format formatter, MultiOptionSearchFilter searchProp, JCheckBoxCellRenderer renderer) {
        super(searchFieldLabel, refreshAction, dataList, formatter);
        this.searchFilter = searchProp;
        this.renderer = renderer;
        this.setUpComboBox();
        this.renderer.getSelectionEventList().addListEventListener((ListEventListener)this);
    }

    private void setUpComboBox() {
        if (this.renderer == null) {
            this.renderer = new JCheckBoxCellRenderer("Any");
        }
        this.getComboBox().setRenderer(this.renderer);
        this.getComboBox().addActionListener(this.renderer);
        this.getComboBox().setEditable(true);
        this.getComboBox().setSelectedItem(this.renderer.getNoneText());
        JTextComponent editor = (JTextComponent)this.getComboBox().getEditor().getEditorComponent();
        editor.setEditable(false);
    }

    public JCheckBoxCellRenderer getRenderer() {
        return this.renderer;
    }

    @Override
    public QuerySearchFilter getSearchProperty() {
        return this.getMultiOptionSearchProperty();
    }

    protected MultiOptionSearchFilter getMultiOptionSearchProperty() {
        if (!this.isEnabled()) {
            this.reset();
        }
        return this.searchFilter;
    }

    @Override
    public void reset() {
        this.searchFilter.clearSearch();
    }

    public void listChanged(ListEvent arg0) {
        this.searchFilter.setSearchOptions((Collection)arg0.getSourceList());
    }

    @Override
    public AbstractComboSearchField setRenderer(ListCellRenderer renderer) {
        if (!(renderer instanceof DefaultListCellRenderer)) {
            throw new IllegalArgumentException("Can only use defaultListCellRenderer, the decorated renderer must return a JLabel as a component");
        }
        this.renderer.setDecoratedRenderer((DefaultListCellRenderer)renderer);
        return this;
    }

    @Override
    public void setVisible(boolean flag) {
        this.getGuiComponent().setVisible(flag);
    }

    @Override
    public boolean isVisible() {
        return this.getGuiComponent().isVisible();
    }

    @Override
    public void setEnabled(boolean flag) {
        this.getGuiComponent().setEnabled(flag);
    }

    @Override
    public boolean isEnabled() {
        return this.getGuiComponent().isEnabled();
    }
}

