/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.search.searchfield.java;

import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.SearchFilterI;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import java.awt.Component;
import java.math.BigDecimal;
import javax.swing.Action;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NumberSearchField
extends SearchGuiField {
    private final JTextField numberField = new JTextField(15);
    private final ISingleValueSearchFilter searchProperty;

    public NumberSearchField(String name, ISingleValueSearchFilter searchProp, Action action, String defaultValue) {
        super(name, null);
        this.numberField.setText(defaultValue);
        this.searchProperty = searchProp;
        this.configureNumberField();
        this.addAction(action);
    }

    private void configureNumberField() {
        this.numberField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                NumberSearchField.this.filterInput();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                NumberSearchField.this.filterInput();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                NumberSearchField.this.filterInput();
            }
        });
    }

    private void filterInput() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String text = NumberSearchField.this.numberField.getText();
                if (!text.matches("\\d*")) {
                    NumberSearchField.this.numberField.setText(text.replaceAll("[^\\d]", ""));
                } else if (!text.equals("") && text != null) {
                    NumberSearchField.this.setSearchValue(new BigDecimal(text));
                }
            }
        });
    }

    @Override
    public Component getGuiComponent() {
        return this.numberField;
    }

    @Override
    public void reset() {
        this.numberField.setText("");
    }

    @Override
    public void addAction(Action action) {
        if (action != null) {
            this.numberField.getDocument().addDocumentListener(new SearchGuiField.DocumentListenerAdapter(action));
        }
    }

    public synchronized void setSearchValue(Object value) {
        if ("".equals(value)) {
            value = null;
        }
        this.searchProperty.setSearchValue(value);
    }

    @Override
    public SearchFilterI getSearchProperty() {
        return this.searchProperty;
    }

    @Override
    public void setEnabled(boolean flag) {
        this.numberField.setEnabled(flag);
    }

    @Override
    public boolean isEnabled() {
        return this.numberField.isEnabled();
    }

    @Override
    public void setVisible(boolean flag) {
        this.numberField.setVisible(flag);
    }

    @Override
    public boolean isVisible() {
        return this.numberField.isVisible();
    }
}

