/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.search.searchfield.java;

import au.com.ordermate.gui.adminkit.AdminGuiUtils;
import au.com.ordermate.gui.renderer.JCheckBoxCellRenderer;
import au.com.ordermate.oquery.search.filter.abstracts.AbstractPolyPropertySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.PolyEmptyPropertySearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.SearchFilterI;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.util.Stringifier;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Format;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class PolyPropertyComboSearchField
extends SearchGuiField
implements ListEventListener,
ActionListener {
    private JPanel searchFieldPanel = new JPanel(new FlowLayout());
    private JComboBox comboBox;
    private JComboBox conditionComboBox;
    private EventComboBoxModel model;
    private EventComboBoxModel conditionModel;
    protected final JCheckBoxCellRenderer checkRenderer;
    private final PolyEmptyPropertySearchFilter searchFilter;

    public PolyPropertyComboSearchField(String searchFieldLabel, PolyEmptyPropertySearchFilter searchProp, Action refreshAction, EventList dataList, EventList dataList2, Format formatter) {
        super(searchFieldLabel, null);
        this.searchFieldPanel.setName(searchFieldLabel);
        this.comboBox = new JComboBox();
        this.comboBox.setName(searchFieldLabel + "ComboBox");
        AdminGuiUtils.getInstance().standardComboSetup(this.comboBox);
        this.conditionComboBox = new JComboBox();
        this.conditionComboBox.setName(searchFieldLabel + "ComboBox");
        AdminGuiUtils.getInstance().standardComboSetup(this.conditionComboBox);
        this.conditionComboBox.setPreferredSize(new Dimension(80, 20));
        if (formatter != null) {
            this.comboBox.setRenderer(this.createRenderer(formatter));
            this.conditionComboBox.setRenderer(this.createRenderer(formatter));
            this.comboBox.setEditable(false);
            this.conditionComboBox.setEditable(false);
        }
        this.searchFieldPanel.add(this.comboBox);
        this.searchFieldPanel.add(this.conditionComboBox);
        this.addAction(refreshAction);
        this.searchFilter = searchProp;
        this.checkRenderer = JCheckBoxCellRenderer.install(this.getComboBox(), "Fields");
        this.checkRenderer.setDecoratedRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value != null) {
                    this.setText(((PropertiedObject.Property)value).getUserVisibleLabel());
                } else {
                    super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                }
                return this;
            }
        });
        this.checkRenderer.setStringFormat(new Stringifier<PropertiedObject.Property>(){

            @Override
            public String stringify(PropertiedObject.Property object) {
                return object.getUserVisibleLabel();
            }
        });
        this.checkRenderer.getSelectionEventList().addListEventListener((ListEventListener)this);
        this.conditionComboBox.addActionListener(this);
        this.setComboListData(dataList);
        this.setSubComboListData(dataList2);
        this.conditionComboBox.setSelectedIndex(0);
    }

    public PolyPropertyComboSearchField(String searchFieldLabel, PolyEmptyPropertySearchFilter searchProp, Action refreshAction, EventList dataList, EventList dataList2) {
        this(searchFieldLabel, searchProp, refreshAction, dataList, dataList2, null);
    }

    public PolyPropertyComboSearchField setRenderer(ListCellRenderer renderer) {
        if (!(renderer instanceof DefaultListCellRenderer)) {
            throw new IllegalArgumentException("Can only use defaultListCellRenderer, the decorated renderer must return a JLabel as a component");
        }
        this.checkRenderer.setDecoratedRenderer((DefaultListCellRenderer)renderer);
        return this;
    }

    public void setComboListData(EventList data) {
        this.model = new EventComboBoxModel(data);
        this.comboBox.setModel(this.model);
    }

    public void setSubComboListData(EventList data) {
        this.conditionModel = new EventComboBoxModel(data);
        this.conditionComboBox.setModel(this.conditionModel);
    }

    protected JComboBox getComboBox() {
        return this.comboBox;
    }

    protected JComboBox getSubComboBox() {
        return this.conditionComboBox;
    }

    @Override
    public Component getGuiComponent() {
        return this.searchFieldPanel;
    }

    @Override
    public void addAction(Action action) {
        if (action != null) {
            this.getComboBox().addActionListener(action);
        }
    }

    @Override
    public void reset() {
        if (this.model.getSize() > 0) {
            this.getComboBox().setSelectedIndex(0);
        }
        if (this.conditionModel.getSize() > 0) {
            this.getSubComboBox().setSelectedIndex(0);
        }
    }

    @Override
    public SearchFilterI getSearchProperty() {
        return this.searchFilter;
    }

    @Override
    public void setVisible(boolean flag) {
        this.comboBox.setVisible(flag);
        this.conditionComboBox.setVisible(flag);
    }

    @Override
    public boolean isVisible() {
        return this.comboBox.isVisible();
    }

    @Override
    public void setEnabled(boolean flag) {
        this.comboBox.setEnabled(flag);
        this.conditionComboBox.setEnabled(flag);
        this.searchFilter.setSearchValue(flag);
    }

    @Override
    public boolean isEnabled() {
        return this.comboBox.isEnabled();
    }

    private ListCellRenderer createRenderer(final Format formatter) {
        DefaultListCellRenderer renderer = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel comp = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                comp.setText(value == null ? null : formatter.format(value));
                return comp;
            }
        };
        return renderer;
    }

    public void listChanged(ListEvent listChanges) {
        EventList props = listChanges.getSourceList();
        PropertiedObject.Property[] array = new PropertiedObject.Property[props.size()];
        for (int i = 0; i < props.size(); ++i) {
            array[i] = (PropertiedObject.Property)props.get(i);
        }
        this.searchFilter.setProperties(array);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.conditionComboBox) {
            this.searchFilter.setCondition((AbstractPolyPropertySearchFilter.Condition)((Object)this.conditionComboBox.getSelectedItem()));
        }
    }
}

