/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.search.searchfield.java;

import au.com.ordermate.oquery.search.filter.implementation.TextSearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.SearchFilterI;
import au.com.ordermate.search.filter.implementation.ContainsTextEventListFilter;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.search.searchfield.java.SearchType;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.JTextField;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;

public class StringSearchField
extends SearchGuiField {
    private final ISingleValueSearchFilter searchProperty;
    private final JTextField textField = new JTextField(15);

    public StringSearchField(String name, PropertiedObject.Property prop) {
        this(name, prop, null);
    }

    public StringSearchField(String name, PropertiedObject.Property prop, Action action) {
        this(name, new TextSearchFilter(prop), action);
    }

    public StringSearchField(String name, SearchType searchType, PropertiedObject.Property property, Action action) {
        this(name, StringSearchField.createDefaultStringSearch(searchType, property), action);
    }

    private static final ISingleValueSearchFilter createDefaultStringSearch(SearchType type, PropertiedObject.Property prop) {
        if (SearchType.QUERY_RESTRICTION.equals((Object)type)) {
            return new TextSearchFilter(prop);
        }
        if (SearchType.EVENTLIST_FILTER.equals((Object)type)) {
            return new ContainsTextEventListFilter(prop);
        }
        throw new IllegalArgumentException("Unknown SearchType for StringSearchField.");
    }

    public StringSearchField(String name, ISingleValueSearchFilter searchProp, Action action) {
        super(name, null);
        this.searchProperty = searchProp;
        this.getTextField().setName(this.getLabel());
        Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.getTextField(), (Property)BeanProperty.create((String)"text"), (Object)this, (Property)BeanProperty.create((String)"searchValue")).bind();
        this.addAction(action);
    }

    @Override
    public Component getGuiComponent() {
        return this.getTextField();
    }

    @Override
    public void reset() {
        this.getTextField().setText("");
    }

    @Override
    public void addAction(Action action) {
        if (action != null) {
            this.getTextField().getDocument().addDocumentListener(new SearchGuiField.DocumentListenerAdapter(action));
        }
    }

    public void addActionToTextField(Action action) {
        this.getTextField().addActionListener(action);
    }

    private JTextField getTextField() {
        return this.textField;
    }

    public synchronized void setSearchValue(Object value) {
        Object searchValue = value;
        if ("".equals(value) && value instanceof String) {
            searchValue = null;
        }
        this.searchProperty.setSearchValue(searchValue);
    }

    @Override
    public SearchFilterI getSearchProperty() {
        if (!this.isEnabled()) {
            this.searchProperty.setSearchValue(null);
        }
        return this.searchProperty;
    }

    @Override
    public void setVisible(boolean flag) {
        this.getGuiComponent().setVisible(flag);
    }

    @Override
    public boolean isVisible() {
        return this.getGuiComponent().isVisible();
    }

    @Override
    public void setEnabled(boolean flag) {
        this.getGuiComponent().setEnabled(flag);
        if (!flag) {
            this.searchProperty.setSearchValue(null);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.getGuiComponent().isEnabled();
    }
}

