/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.serialization;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.serialization.AbstractObjectIO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.kxml2.io.KXmlParser;
import org.kxml2.io.KXmlSerializer;

public abstract class AbstractMasterIdIO
extends AbstractObjectIO<List<? extends PropertiedObject>> {
    private static final String CLASS = "class";
    private static final String NAME = "name";
    private static final String OBJECTS = "objects";
    private static final String OBJECT = "object";
    private static final String MID = "masterId";
    private static final String ID = "id";

    @Override
    protected void serialize(List<? extends PropertiedObject> objects, KXmlSerializer docSerializer) throws IOException {
        Collections.sort(objects, new ClassComparator());
        docSerializer.startTag(null, OBJECTS);
        Class lastClass = Object.class;
        PropertiedObject.Property midProperty = null;
        for (PropertiedObject propertiedObject : objects) {
            if (!lastClass.equals(propertiedObject.getClass())) {
                if (midProperty != null) {
                    docSerializer.endTag(null, CLASS);
                    midProperty = null;
                }
                lastClass = propertiedObject.getClass();
                midProperty = propertiedObject.getProperties().getProperty(MID);
                if (midProperty != null) {
                    docSerializer.startTag(null, CLASS);
                    docSerializer.attribute(null, NAME, propertiedObject.getClass().getCanonicalName());
                }
            }
            if (midProperty == null) continue;
            docSerializer.startTag(null, OBJECT);
            docSerializer.attribute(null, ID, String.valueOf(propertiedObject.getProperties().getProperty("ID").resolveValue(propertiedObject)));
            Long mid = (Long)midProperty.resolveValue(propertiedObject);
            if (mid != null) {
                docSerializer.attribute(null, MID, mid.toString());
            }
            docSerializer.endTag(null, OBJECT);
        }
        if (midProperty != null) {
            docSerializer.endTag(null, CLASS);
        }
        docSerializer.endTag(null, OBJECTS);
    }

    @Override
    protected List<? extends PropertiedObject> deserialize(KXmlParser parser) throws Exception {
        ArrayList<PropertiedObject> things = new ArrayList<PropertiedObject>();
        PropertiedObject obj = null;
        while (parser.nextTag() == 2) {
            parser.require(2, null, CLASS);
            Class<?> clazz = null;
            try {
                clazz = Class.forName(parser.getAttributeValue(null, NAME));
            }
            catch (Exception ex) {
                this.handleParsingException(ex);
            }
            if (clazz == null) {
                parser.skipSubTree();
                continue;
            }
            while (parser.nextTag() == 2) {
                parser.require(2, null, OBJECT);
                obj = this.resolveAndSet(clazz, parser.getAttributeValue(null, ID), parser.getAttributeValue(null, MID));
                if (obj != null) {
                    things.add(obj);
                }
                parser.nextTag();
                parser.require(3, null, OBJECT);
            }
            parser.require(3, null, CLASS);
        }
        return things;
    }

    protected abstract void handleParsingException(Exception var1);

    protected abstract PropertiedObject resolveAndSet(Class var1, String var2, String var3);

    class ClassComparator
    implements Comparator<PropertiedObject> {
        ClassComparator() {
        }

        @Override
        public int compare(PropertiedObject arg0, PropertiedObject arg1) {
            if (arg0 == null) {
                return arg1 == null ? 0 : -1;
            }
            if (arg1 == null) {
                return 1;
            }
            return arg0.getClass().getName().compareTo(arg1.getClass().getName());
        }
    }
}

