/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.serialization;

import au.com.ordermate.serialization.IdentifierGenerator;
import au.com.ordermate.serialization.NullIdentifierGenerator;
import java.util.HashMap;
import java.util.Map;

public class IdentityCache {
    private final Map<Object, Object> cache = new HashMap<Object, Object>();
    private final IdentifierGenerator generator;

    public IdentityCache(IdentifierGenerator yourGenerator) {
        this.generator = yourGenerator == null ? new NullIdentifierGenerator() : yourGenerator;
    }

    public void clear() {
        this.cache.clear();
    }

    public boolean putInCache(Object thing) {
        String identifier = this.generator.getIdentifier(thing);
        if (identifier != null) {
            this.cache.put(identifier, thing);
            return true;
        }
        return false;
    }

    public boolean hasInCache(Object thing) {
        String identifier = this.generator.getIdentifier(thing);
        return identifier != null && this.cache.containsKey(identifier);
    }

    public Object getFromCache(Object thing) {
        String identifier = this.generator.getIdentifier(thing);
        if (identifier != null) {
            return this.cache.get(identifier);
        }
        return null;
    }

    public String getIdFor(Object thing) {
        return this.generator.getIdentifier(thing);
    }

    public Object getById(String id) {
        return id == null ? null : this.cache.get(id);
    }
}

