/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.serialization;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.serialization.DefaultReferenceStrategy;
import au.com.ordermate.serialization.IOReferenceStrategy;
import au.com.ordermate.serialization.PropertiedObjectIO;
import java.io.IOException;
import java.util.Collection;
import org.kxml2.io.KXmlSerializer;

public class PersistentObjectReferenceStrategy
extends DefaultReferenceStrategy
implements IOReferenceStrategy {
    private static final String REF_PROP = "ref_prop";
    private static final String OBJECT_ID = "obj_id";

    public PersistentObjectReferenceStrategy(PropertiedObjectIO io) {
        super(io);
    }

    @Override
    public void handleMultiRef(Collection references, KXmlSerializer docSerializer, PropertiedObject.Property prop, PropertiedObject referer) throws IOException {
        for (Object nextRef : references) {
            if (nextRef instanceof PersistentObject) {
                this.handleSingleRef((PropertiedObject)nextRef, docSerializer, prop, referer);
                continue;
            }
            if (!(nextRef instanceof PropertiedObject)) continue;
            this.io.serializeToXML(docSerializer, (PropertiedObject)nextRef, prop, referer);
        }
    }

    @Override
    public void handleSingleRef(PropertiedObject reference, KXmlSerializer docSerializer, PropertiedObject.Property prop, PropertiedObject referer) throws IOException {
        String clazz = reference.getClass().getCanonicalName();
        if (reference instanceof PersistentObject) {
            docSerializer.startTag(null, clazz);
            docSerializer.attribute(null, REF_PROP, prop.getName());
            docSerializer.attribute(null, OBJECT_ID, ((PersistentObject)reference).getID().toString());
            docSerializer.endTag(null, clazz);
        } else {
            super.handleSingleRef(reference, docSerializer, prop, referer);
        }
    }
}

