/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.serialization;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.reflect.ReflectUtils;
import au.com.ordermate.serialization.AbstractObjectIO;
import au.com.ordermate.serialization.DefaultReferenceStrategy;
import au.com.ordermate.serialization.IOReferenceStrategy;
import au.com.ordermate.serialization.IdentifierGenerator;
import au.com.ordermate.serialization.IdentityCache;
import au.com.ordermate.serialization.ObjectResolver;
import au.com.ordermate.serialization.PosDBIdentifierGenerator;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import ordermate.jaxb.exporter.handlers.posdatabase.converters.Converter;
import ordermate.jaxb.exporter.handlers.posdatabase.converters.Converters;
import org.kxml2.io.KXmlParser;
import org.kxml2.io.KXmlSerializer;
import org.xmlpull.v1.XmlPullParserException;

public class PropertiedObjectIO<T extends PropertiedObject>
extends AbstractObjectIO<T> {
    private static final String REF_PROP = "ref_prop";
    private static final String PARENT = "_parent";
    private static final String GEN_ID = "_gen_id";
    private static final String OBJECT_ID = "obj_id";
    protected final List<PropertiedObject.Property> exclusionProps = new ArrayList<PropertiedObject.Property>();
    private IOReferenceStrategy referenceStrategy;
    private ObjectResolver objResolver;
    private final IdentifierGenerator idGen;
    private IdentityCache cache;

    public PropertiedObjectIO() {
        this.addDefaultPropsToBeExcluded();
        this.referenceStrategy = new DefaultReferenceStrategy(this);
        this.idGen = this.createIdentifierGenerator();
        this.cache = new IdentityCache(this.idGen);
    }

    protected IdentifierGenerator createIdentifierGenerator() {
        return new PosDBIdentifierGenerator();
    }

    public IdentityCache getCache() {
        return this.cache;
    }

    public void setReferenceStrategy(IOReferenceStrategy strategy) {
        this.referenceStrategy = strategy;
    }

    public void setObjResolver(ObjectResolver objResolver) {
        this.objResolver = objResolver;
    }

    protected void addDefaultPropsToBeExcluded() {
        this.exclusionProps.addAll(Arrays.asList(PersistentObject.Properties.MOD_COUNT, PersistentObject.Properties.VERSION, PersistentObject.Properties.STORE_ID));
    }

    public void addExclusionProperty(PropertiedObject.Property property) {
        if (property != null) {
            this.exclusionProps.add(property);
        }
    }

    protected void serializeToXML(KXmlSerializer docSerializer, PropertiedObject toSerialize, PropertiedObject.Property accessor, PropertiedObject parent) throws IOException {
        Object value;
        if (this.cache.hasInCache(toSerialize)) {
            this.handleAlreadyContains(toSerialize, docSerializer, accessor, parent);
            return;
        }
        this.cache.putInCache(toSerialize);
        String clazz = toSerialize.getClass().getCanonicalName();
        docSerializer.startTag(null, clazz);
        if (accessor != null) {
            docSerializer.attribute(null, REF_PROP, accessor.getName());
        }
        ArrayList<PropertiedObject.Property<Object>> refs = new ArrayList<PropertiedObject.Property<Object>>();
        PropertiedObject.Props props = toSerialize.getProperties();
        for (PropertiedObject.Property<Object> prop : props) {
            if (!this.canSerialize(prop)) continue;
            value = prop.resolveValue(toSerialize);
            if (value instanceof Collection || value instanceof PropertiedObject) {
                if (parent != null && parent.equals(value)) {
                    docSerializer.attribute(null, prop.getName(), PARENT);
                    continue;
                }
                refs.add(prop);
                continue;
            }
            if ((value = this.convertToString(value, prop, prop.getName())) == null) continue;
            docSerializer.attribute(null, prop.getName(), (String)value);
        }
        for (PropertiedObject.Property<Object> prop : refs) {
            value = prop.resolveValue(toSerialize);
            if (value instanceof Collection) {
                this.handleMultiRef((Collection)value, docSerializer, prop, toSerialize);
                continue;
            }
            if (!(value instanceof PropertiedObject)) continue;
            this.handleSingleRef((PropertiedObject)value, docSerializer, prop, toSerialize);
        }
        docSerializer.endTag(null, clazz);
    }

    protected void handleAlreadyContains(PropertiedObject toSerialize, KXmlSerializer docSerializer, PropertiedObject.Property refProp, PropertiedObject parent) throws IOException {
        String id = this.idGen.getIdentifier(toSerialize);
        if (id != null && refProp != null) {
            docSerializer.startTag(null, toSerialize.getClass().getCanonicalName());
            docSerializer.attribute(null, REF_PROP, refProp.getName());
            docSerializer.attribute(null, GEN_ID, id);
            docSerializer.endTag(null, toSerialize.getClass().getCanonicalName());
        }
    }

    protected void handleMultiRef(Collection<PropertiedObject> references, KXmlSerializer docSerializer, PropertiedObject.Property prop, PropertiedObject referer) throws IOException {
        this.referenceStrategy.handleMultiRef(references, docSerializer, prop, referer);
    }

    protected void handleSingleRef(PropertiedObject reference, KXmlSerializer docSerializer, PropertiedObject.Property prop, PropertiedObject referer) throws IOException {
        this.referenceStrategy.handleSingleRef(reference, docSerializer, prop, referer);
    }

    protected String convertToString(Object value, PropertiedObject.Property prop, String propName) {
        if (value != null) {
            Converter converter = Converters.getConverterFor(value.getClass());
            if (converter == null) {
                this.logWarning("Converter is not found for the specified property value: " + prop, null);
                return null;
            }
            return converter.convertToString(value);
        }
        return null;
    }

    private boolean canSerialize(PropertiedObject.Property prop) {
        return !this.exclusionProps.contains(prop);
    }

    private PropertiedObject deserializeFromXml(KXmlParser parser, Class<? extends PropertiedObject> type, PropertiedObject parent) throws InstantiationException, IllegalAccessException, XmlPullParserException, IOException, ClassNotFoundException {
        int next;
        PropertiedObject.Property prop;
        PropertiedObject t = type.newInstance();
        HashMap refMap = new HashMap();
        parser.require(2, null, null);
        if (parser.getAttributeValue(null, GEN_ID) != null) {
            t = (PropertiedObject)this.cache.getById(parser.getAttributeValue(null, GEN_ID));
        }
        String refProp = null;
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            String attribute = parser.getAttributeName(i);
            if (REF_PROP.equals(attribute)) {
                refProp = parser.getAttributeValue(null, REF_PROP);
                continue;
            }
            if (GEN_ID.equals(attribute)) continue;
            if (OBJECT_ID.equals(attribute)) {
                Class<?> clazz;
                String objID = parser.getAttributeValue(null, OBJECT_ID);
                t = (PropertiedObject)this.objResolver.resolve(objID, clazz = Class.forName(parser.getName()));
                if (this.cache.hasInCache(t)) {
                    // empty if block
                }
                this.cache.putInCache(t);
                continue;
            }
            String value = parser.getAttributeValue(i);
            prop = this.resolveProperty(t, attribute);
            if (prop == null) continue;
            try {
                if (PARENT.equals(value)) {
                    this.roughlyInsert(t, parent, prop);
                    continue;
                }
                Object actual = this.convertFromString(value, prop, attribute);
                try {
                    PropertiedObject.PropsHelper.setPropertyValue(t, prop, actual);
                }
                catch (Exception ex) {
                    this.manuallyInsert(t, prop, actual);
                }
                catch (Throwable ex2) {
                    this.logWarning("Cannot set property, skipping " + attribute + " with " + value, null);
                }
                continue;
            }
            catch (Throwable ex) {
                this.logWarning("Cannot insert into parent, skipping " + attribute + " with " + value, null);
            }
        }
        if (this.cache.hasInCache(t)) {
            parser.skipSubTree();
            return (PropertiedObject)this.cache.getFromCache(t);
        }
        this.cache.putInCache(t);
        while ((next = parser.nextTag()) == 2) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(parser.getName());
                String property = parser.getAttributeValue(parser.getNamespace(), REF_PROP);
                prop = this.resolveProperty(t, property);
                if (prop != null) {
                    PropertiedObject nextRef;
                    if (!refMap.containsKey(prop)) {
                        refMap.put(prop, new ArrayList());
                    }
                    if ((nextRef = this.deserializeFromXml(parser, clazz, t)) == null || ((List)refMap.get(prop)).contains(nextRef)) continue;
                    ((List)refMap.get(prop)).add(nextRef);
                    continue;
                }
                parser.skipSubTree();
                this.logWarning("Cannot find property :" + property + " for " + t.getClass(), null);
            }
            catch (ClassNotFoundException ex) {
                this.handleUnknownClass(parser);
            }
        }
        for (PropertiedObject.Property prop2 : refMap.keySet()) {
            try {
                Object actual = refMap.get(prop2);
                this.roughlyInsert(t, actual, prop2);
            }
            catch (Exception ex) {
                this.logWarning("Cannot set list or ref property, skipping " + prop2, ex);
            }
        }
        return t;
    }

    protected void handleUnknownClass(KXmlParser parser) throws IOException, XmlPullParserException {
        int tag;
        String unknownClazz = parser.getName();
        this.logWarning("Handling unknown class " + unknownClazz, null);
        int depth = parser.getDepth();
        while (!((tag = parser.nextTag()) == 1 || tag == 3 && unknownClazz.equals(parser.getName()) && parser.getDepth() == depth || parser.getDepth() <= depth)) {
        }
    }

    protected PropertiedObject.Property resolveProperty(PropertiedObject t, String propName) {
        if (propName == null) {
            return null;
        }
        return t.getProperties().getProperty(propName);
    }

    void roughlyInsert(PropertiedObject propertiedObject, Object value, PropertiedObject.Property prop) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (value instanceof List && !List.class.isAssignableFrom(prop.getObjectType())) {
            if (((List)value).isEmpty()) {
                return;
            }
            value = ((List)value).get(0);
        }
        if (value != null) {
            this.manuallyInsert(propertiedObject, prop, value);
        }
    }

    protected void manuallyInsert(PropertiedObject propertiedObject, PropertiedObject.Property prop, Object value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method method = this.findSetterMethod(propertiedObject.getClass(), prop, value);
        if (method != null) {
            method.setAccessible(true);
            method.invoke((Object)propertiedObject, value);
            method.setAccessible(false);
        }
    }

    private Method findSetterMethod(Class clazz, PropertiedObject.Property prop, Object value) {
        Method method;
        try {
            Class<Object> classToUse = prop.getObjectType();
            if (classToUse.isAssignableFrom(Reference.class)) {
                classToUse = value.getClass();
            }
            method = clazz.getDeclaredMethod(ReflectUtils.convertPropertyName(prop.getName(), "set"), classToUse);
        }
        catch (Exception ex) {
            method = null;
        }
        if (method == null) {
            try {
                method = clazz.getDeclaredMethod(ReflectUtils.convertPropertyName(prop.getName(), "set"), Object.class);
            }
            catch (Exception ex) {
                method = null;
            }
        }
        if (method == null && !Object.class.equals(clazz.getSuperclass())) {
            method = this.findSetterMethod(clazz.getSuperclass(), prop, value);
        }
        if (method == null) {
            this.logWarning("Cannot find setter " + clazz + " for prop " + prop, null);
        }
        return method;
    }

    protected Object convertFromString(String value, PropertiedObject.Property prop, String propName) {
        Converter converter = Converters.getConverterFor(prop.getActualObjectType());
        return converter != null ? converter.convertFromString(value) : value;
    }

    @Override
    protected void serialize(T toSerialize, KXmlSerializer docSerializer) throws IOException {
        this.serializeToXML(docSerializer, (PropertiedObject)toSerialize, null, null);
    }

    @Override
    protected T deserialize(KXmlParser parser) throws InstantiationException, IllegalAccessException, XmlPullParserException, IOException, ClassNotFoundException {
        Class<?> clazz = Class.forName(parser.getName());
        return (T)this.deserializeFromXml(parser, clazz, null);
    }

    protected void logWarning(String log, Exception ex) {
    }
}

