/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.serialization;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.serialization.DefaultReferenceStrategy;
import au.com.ordermate.serialization.IOReferenceStrategy;
import au.com.ordermate.serialization.PropertiedObjectIO;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.kxml2.io.KXmlSerializer;

public class ShortReferenceStrategy
extends DefaultReferenceStrategy
implements IOReferenceStrategy {
    private final Map<Class, Integer> depthMap;
    private int singleRef = 0;
    private int DEPTH = 1;

    public ShortReferenceStrategy(PropertiedObjectIO io) {
        this(io, 1);
    }

    public ShortReferenceStrategy(PropertiedObjectIO io, int depth) {
        super(io);
        io.setReferenceStrategy(this);
        this.DEPTH = depth;
        this.depthMap = new HashMap<Class, Integer>();
    }

    @Override
    public void handleMultiRef(Collection references, KXmlSerializer docSerializer, PropertiedObject.Property prop, PropertiedObject referer) throws IOException {
        if (!this.depthMap.containsKey(referer.getClass())) {
            super.handleMultiRef(references, docSerializer, prop, referer);
        }
    }

    @Override
    public void handleSingleRef(PropertiedObject reference, KXmlSerializer docSerializer, PropertiedObject.Property prop, PropertiedObject referer) throws IOException {
        Class<?> clazz = reference.getClass();
        Integer count = this.depthMap.get(clazz);
        if (this.singleRef == 0) {
            ++this.singleRef;
            if (count == null || count < this.DEPTH) {
                count = count == null ? 1 : count + 1;
                this.depthMap.put(clazz, count);
                super.handleSingleRef(reference, docSerializer, prop, referer);
                if (count == 1) {
                    this.depthMap.remove(clazz);
                } else {
                    this.depthMap.put(clazz, this.depthMap.get(clazz) - 1);
                }
            }
            --this.singleRef;
        }
    }
}

