/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.simplermi;

import au.com.ordermate.simplermi.SimpleRMI;
import au.com.ordermate.simplermi.SimpleRMIDecorator;
import java.net.InetAddress;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;

public abstract class AbstractSimpleRMIDecorator<T extends Remote>
implements SimpleRMIDecorator<T> {
    private T remote;
    private String objectName;

    public AbstractSimpleRMIDecorator(String objectName) {
        if (objectName == null) {
            throw new IllegalArgumentException("objectName cannot be null! Insert the name of the concrete class that is a Remote");
        }
        this.objectName = objectName;
    }

    @Override
    public synchronized void setRemote(T admin) {
        this.remote = admin;
    }

    @Override
    public synchronized T getRemoteAdministrator() {
        this.resolve();
        return this.remote;
    }

    protected InetAddress getAddress() {
        return Terminal.getServerMateTerminal().getAddress();
    }

    protected int getPort() {
        return 11100;
    }

    protected synchronized boolean resolve() {
        if (this.remote == null) {
            try {
                this.remote = SimpleRMI.getObject(this.getAddress(), this.objectName, this.getPort());
            }
            catch (RemoteException e) {
                OrderMate.LOG.error("Cannot retrieve " + this.objectName + " from ServerMate", (Throwable)e);
            }
            catch (NotBoundException e) {
                OrderMate.LOG.error("Cannot retrieve " + this.objectName + " from ServerMate, Not shared?", (Throwable)e);
            }
        }
        return this.remote != null;
    }
}

