/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.simplermi;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.IPAddressUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import ordermate.database.hardware.Terminal;

class RMISocketFactory
implements RMIClientSocketFactory,
RMIServerSocketFactory {
    private static final int DEFAULT_BACKLOG = 50;

    RMISocketFactory() {
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        if (PersistenceManager.isPersistenceSetup() && Terminal.isLocalHostSetup()) {
            for (InetAddress localhost : IPAddressUtils.getLocalAddresses()) {
                if (!localhost.equals(Terminal.getLocalHost().getAddress())) continue;
                return new ServerSocket(port, 50, localhost);
            }
        }
        return new ServerSocket(port, 50, InetAddress.getLocalHost());
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return new Socket(host, port);
    }
}

