/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.simplermi;

import java.net.BindException;
import java.net.InetAddress;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ExportException;
import java.rmi.server.UnicastRemoteObject;
import java.security.Permission;
import java.util.Arrays;
import ordermate.OrderMate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleRMI {
    private static final int MAX_RETRIES = 30;
    private static final int BACKOFF = 2000;
    private static Registry localRmiRegistry;
    private static int thePort;
    private static Log LOG;

    public static synchronized boolean isInitialized() {
        return localRmiRegistry != null;
    }

    public static synchronized void startSharing(boolean retry, int ... shareRegistryPorts) throws RemoteException {
        if (SimpleRMI.getLocalRmiRegistry() != null) {
            throw new IllegalStateException("startSharing can only be called once");
        }
        if (thePort != 0) {
            boolean found = false;
            for (int nextPort : shareRegistryPorts) {
                if (thePort != nextPort) continue;
                found = true;
            }
            if (!found) {
                throw new IllegalStateException("startSharing was previously called with port " + thePort);
            }
        }
        int[] availablePorts = shareRegistryPorts;
        if (thePort != 0) {
            availablePorts = new int[]{thePort};
        }
        System.setSecurityManager(new SecurityManager(){

            @Override
            public void checkPermission(Permission perm) {
            }

            @Override
            public void checkPermission(Permission perm, Object context) {
            }

            @Override
            public void checkDelete(String file) {
                if (file != null) {
                    super.checkDelete(file);
                }
            }
        });
        int lastKnownPort = 0;
        boolean success = false;
        int numRetries = 0;
        RemoteException remoteError = null;
        OrderMate.LOG.info("Starting with available RMI Ports:" + Arrays.toString(availablePorts));
        while (!success) {
            for (int nextPort : availablePorts) {
                Exception error = SimpleRMI.createRegistry(nextPort);
                if (error == null) {
                    lastKnownPort = 0;
                    success = true;
                    break;
                }
                if (!(error instanceof RemoteException)) continue;
                lastKnownPort = nextPort;
                remoteError = (RemoteException)error;
            }
            if (retry && ++numRetries <= 30) continue;
        }
        if (lastKnownPort != 0) {
            if (remoteError != null && !retry) {
                throw remoteError;
            }
            LOG.warn((Object)("RMI registry seems to be running on port :" + lastKnownPort + ". Attempting to continue..."));
            SimpleRMI.setLocalRmiRegistry(LocateRegistry.getRegistry(lastKnownPort), lastKnownPort);
        }
    }

    private static Exception createRegistry(int useThisPort) {
        RemoteException exception = null;
        try {
            SimpleRMI.setLocalRmiRegistry(LocateRegistry.createRegistry(useThisPort), useThisPort);
            LOG.info((Object)("Created RMI registry on port " + useThisPort));
        }
        catch (ExportException e) {
            Throwable cause = e.getCause();
            if (cause instanceof BindException && cause.getMessage().equals("Address already in use: JVM_Bind")) {
                try {
                    int backoff = 2000 + (int)(Math.random() * 1000.0);
                    LOG.warn((Object)("RMI PORT " + useThisPort + " in use. Waiting " + backoff + "ms for socket in TIME_WAIT state"));
                    Thread.sleep(backoff);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
            }
            exception = e;
        }
        catch (RemoteException ex) {
            LOG.warn((Object)"Error creating RMI registry!", (Throwable)ex);
            exception = ex;
        }
        return exception;
    }

    public static synchronized int getSharePort() {
        return thePort;
    }

    public static Remote shareObject(Remote toShare, String name) throws RemoteException {
        if (SimpleRMI.getLocalRmiRegistry() == null) {
            throw new IllegalStateException("You must call startSharing before calling shareObject");
        }
        try {
            SimpleRMI.getLocalRmiRegistry().bind(name, toShare);
            return toShare;
        }
        catch (AlreadyBoundException e) {
            LOG.error((Object)("*** Error! " + name + " is already bound ... using remote ref ***"));
            try {
                return SimpleRMI.getLocalRmiRegistry().lookup(name);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static synchronized boolean isSharingObject(String name) throws RemoteException {
        try {
            Remote object = SimpleRMI.getLocalRmiRegistry().lookup(name);
            return object != null;
        }
        catch (NotBoundException ex) {
            return false;
        }
    }

    public static Remote getObject(InetAddress host, String name, int registryPort) throws RemoteException, NotBoundException {
        if (host == null) {
            throw new IllegalArgumentException("Host is null!");
        }
        Registry rmiRegistry = LocateRegistry.getRegistry(host.getHostAddress(), registryPort);
        Remote uncasted = rmiRegistry.lookup(name);
        return uncasted;
    }

    public static synchronized void unshareObject(String name) {
        if (SimpleRMI.getLocalRmiRegistry() == null) {
            throw new IllegalStateException("You must call startSharing before calling unshareObject");
        }
        try {
            Remote toRemove = SimpleRMI.getLocalRmiRegistry().lookup(name);
            UnicastRemoteObject.unexportObject(toRemove, true);
            SimpleRMI.getLocalRmiRegistry().unbind(name);
        }
        catch (NotBoundException e) {
            LOG.error((Object)(name + " was never shared!"), (Throwable)e);
        }
        catch (RemoteException e) {
            LOG.error((Object)("Error unsharing object " + name), (Throwable)e);
        }
    }

    public static synchronized void shutdown() {
        SimpleRMI.shutdown(false);
    }

    public static synchronized void shutdown(boolean throwExceptions) {
        LOG.error((Object)"Shutting down RMI");
        if (SimpleRMI.getLocalRmiRegistry() != null) {
            try {
                String[] boundObjects = SimpleRMI.getLocalRmiRegistry().list();
                for (int i = 0; i < boundObjects.length; ++i) {
                    SimpleRMI.unshareObject(boundObjects[i]);
                }
                UnicastRemoteObject.unexportObject(SimpleRMI.getLocalRmiRegistry(), true);
                SimpleRMI.setLocalRmiRegistry(null, 0);
            }
            catch (Exception e) {
                if (throwExceptions) {
                    throw new RuntimeException(e);
                }
                LOG.error((Object)"Error shuting down RMI", (Throwable)e);
            }
        }
    }

    private static synchronized void setLocalRmiRegistry(Registry localRegistry, int rmiPort) {
        localRmiRegistry = localRegistry;
        thePort = rmiPort;
    }

    private static synchronized Registry getLocalRmiRegistry() {
        return localRmiRegistry;
    }

    static {
        LOG = LogFactory.getLog(SimpleRMI.class);
    }
}

