/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.sql;

import au.com.ordermate.sql.Dialect;

public abstract class AbstractDialect
implements Dialect {
    @Override
    public String where(String[] conds) {
        StringBuffer str = new StringBuffer();
        if (conds != null) {
            str.append("WHERE ");
            for (int i = 0; i < conds.length; ++i) {
                if (i != 0) {
                    str.append("AND ");
                }
                str.append(conds[i] + " ");
            }
        }
        return str.toString();
    }

    @Override
    public String join(String[] tables) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < tables.length - 1; ++i) {
            if (i != 0) {
                str.append("AND ");
            }
            String t1 = tables[i];
            String t2 = tables[i + 1];
            str.append(t1 + ".FK_" + t2 + " = " + t2 + ".ID ");
        }
        return str.toString();
    }

    @Override
    public String isActive(String table) {
        return table + ".system_state = '" + "ACTIVE" + "' ";
    }

    @Override
    public String isDeleted(String table) {
        return table + ".system_state = '" + "DELETED" + "' ";
    }

    @Override
    public String select(String[] fields, String table, String[] whereConds) {
        StringBuffer sql = new StringBuffer("SELECT ");
        for (int i = 0; i < fields.length; ++i) {
            if (i != 0) {
                sql.append(", ");
            }
            sql.append(fields[i]);
        }
        sql.append(" FROM " + table + " ");
        sql.append(this.where(whereConds));
        return sql.toString();
    }

    @Override
    public String insert(String table, String[] cols) {
        StringBuffer sql = new StringBuffer("INSERT INTO ");
        sql.append(table);
        StringBuffer colsString = new StringBuffer();
        StringBuffer paramsString = new StringBuffer();
        for (int i = 0; i < cols.length; ++i) {
            colsString.append(cols[i]);
            paramsString.append('?');
            if (i >= cols.length - 1) continue;
            colsString.append(", ");
            paramsString.append(", ");
        }
        sql.append(" (");
        sql.append(colsString);
        sql.append(") VALUES (");
        sql.append(paramsString);
        sql.append(')');
        return sql.toString();
    }

    @Override
    public String update(String table, String[] cols, boolean isVersioned) {
        StringBuffer sql = new StringBuffer("UPDATE ");
        sql.append(table);
        sql.append(" SET");
        for (int i = 0; i < cols.length; ++i) {
            sql.append(' ');
            sql.append(cols[i]);
            sql.append(" = ?");
            if (i >= cols.length - 1) continue;
            sql.append(',');
        }
        if (isVersioned) {
            sql.append(", VERSION = VERSION + 1");
        }
        sql.append(" WHERE ID = ?");
        return sql.toString();
    }

    @Override
    public String updateBulk(String table, String[] cols, int numIds) {
        int i;
        StringBuilder sql = new StringBuilder("UPDATE ");
        sql.append(table);
        sql.append(" SET");
        for (i = 0; i < cols.length; ++i) {
            sql.append(" ");
            sql.append(cols[i]);
            sql.append(" = ?");
            if (i >= cols.length - 1) continue;
            sql.append(',');
        }
        sql.append(" WHERE ID IN(");
        for (i = 0; i < numIds; ++i) {
            sql.append("?,");
        }
        sql.setCharAt(sql.length() - 1, ')');
        return sql.toString();
    }

    @Override
    public String delete(String table) {
        StringBuffer sql = new StringBuffer("DELETE FROM ");
        sql.append(table);
        sql.append(" WHERE ID = ?");
        return sql.toString();
    }

    @Override
    public abstract String lastInsertID();

    @Override
    public abstract boolean supportsTableNameColumnSelection();
}

