/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.sql;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.sql.AbstractDialect;

public class MySQLDialect
extends AbstractDialect {
    @Override
    public String lastInsertID() {
        return "SELECT LAST_INSERT_ID()";
    }

    @Override
    public boolean supportsTableNameColumnSelection() {
        return true;
    }

    @Override
    public boolean supportsLock() {
        return true;
    }

    @Override
    public String lock(String table) throws UnsupportedOperationException {
        if (table == null || table.length() == 0) {
            throw new NullPointerException("Table name is null or empty, cannot create a LOCK statement.");
        }
        return "LOCK TABLES " + table + " WRITE";
    }

    @Override
    public String unlock(String table) throws UnsupportedOperationException {
        if (table == null || table.length() == 0) {
            throw new NullPointerException("Table name is null or empty, cannot create a UNLOCK statement.");
        }
        return "UNLOCK TABLES " + table + " WRITE";
    }

    @Override
    public String unlock() throws UnsupportedOperationException {
        return "UNLOCK TABLES";
    }

    @Override
    public boolean supportsReturnGeneratedKeys() {
        return !Config.getBooleanValue("disableGeneratedKey");
    }
}

