/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.sql;

import au.com.ordermate.sql.Dialect;
import au.com.ordermate.sql.MySQLDialect;
import au.com.ordermate.sql.queries.SelectQuery;

public class SQL {
    public static final Dialect defaultDialect = new MySQLDialect();
    private static Dialect currentDialect;

    public static void setDialect(Dialect newDialect) {
        if (currentDialect != null) {
            throw new IllegalStateException("Cannot set the Dialect once it has already been set.");
        }
        currentDialect = newDialect;
    }

    public static boolean hasDialect() {
        return currentDialect != null;
    }

    public static Dialect getDialect() {
        return currentDialect;
    }

    public static void clearDialect() {
        currentDialect = null;
    }

    private static void checkDialect() {
        if (!SQL.hasDialect()) {
            currentDialect = defaultDialect;
        }
    }

    public static SelectQuery createQuery() {
        SQL.checkDialect();
        return new SelectQuery();
    }

    public static SelectQuery createQuery(String fromTable) {
        SQL.checkDialect();
        return new SelectQuery(fromTable);
    }

    public static SelectQuery createQuery(String[] fromTables) {
        SQL.checkDialect();
        return new SelectQuery(fromTables);
    }

    public static SelectQuery createQuery(SelectQuery copy) {
        SQL.checkDialect();
        return new SelectQuery(copy);
    }

    public static String where(String cond1, String cond2) {
        return SQL.where(new String[]{cond1, cond2});
    }

    public static String where(String cond1, String cond2, String cond3) {
        return SQL.where(new String[]{cond1, cond2, cond3});
    }

    public static String where(String cond1, String cond2, String cond3, String cond4) {
        return SQL.where(new String[]{cond1, cond2, cond3, cond4});
    }

    public static String where(String[] conds) {
        SQL.checkDialect();
        return currentDialect.where(conds);
    }

    public static String join(String table1, String table2) {
        return SQL.join(new String[]{table1, table2});
    }

    public static String join(String table1, String table2, String table3) {
        return SQL.join(new String[]{table1, table2, table3});
    }

    public static String join(String table1, String table2, String table3, String table4) {
        return SQL.join(new String[]{table1, table2, table3, table4});
    }

    public static String join(String table1, String table2, String table3, String table4, String table5) {
        return SQL.join(new String[]{table1, table2, table3, table4, table5});
    }

    public static String join(String[] tables) {
        SQL.checkDialect();
        return currentDialect.join(tables);
    }

    public static String isActive(String table) {
        SQL.checkDialect();
        return currentDialect.isActive(table);
    }

    public static String isDeleted(String table) {
        SQL.checkDialect();
        return currentDialect.isDeleted(table);
    }

    public static String select(String[] fields, String table, String[] whereConds) {
        SQL.checkDialect();
        return currentDialect.select(fields, table, whereConds);
    }

    public static String insert(String table, String[] cols) {
        SQL.checkDialect();
        return currentDialect.insert(table, cols);
    }

    public static String update(String table, String[] cols, boolean isVersioned) {
        SQL.checkDialect();
        return currentDialect.update(table, cols, isVersioned);
    }

    public static String updateBulk(String table, String[] cols, int numIds) {
        SQL.checkDialect();
        return currentDialect.updateBulk(table, cols, numIds);
    }

    public static String delete(String table) {
        SQL.checkDialect();
        return currentDialect.delete(table);
    }

    public static String lastInsertID() {
        SQL.checkDialect();
        return currentDialect.lastInsertID();
    }

    public static boolean supportsTableNameColumnSelection() {
        SQL.checkDialect();
        return currentDialect.supportsTableNameColumnSelection();
    }

    public static String lock(String table) throws UnsupportedOperationException {
        SQL.checkDialect();
        return currentDialect.lock(table);
    }

    public static String unlock(String table) throws UnsupportedOperationException {
        SQL.checkDialect();
        return currentDialect.unlock(table);
    }

    public static String unlock() throws UnsupportedOperationException {
        SQL.checkDialect();
        return currentDialect.unlock();
    }

    public static boolean supportsLock() {
        SQL.checkDialect();
        return currentDialect.supportsLock();
    }

    public static boolean supportsReturnGeneratedKeys() {
        SQL.checkDialect();
        return currentDialect.supportsReturnGeneratedKeys();
    }
}

