/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.sql.queries;

import au.com.ordermate.sql.queries.SQLElement;

public class Operator
extends SQLElement {
    public static final Operator LESS_THAN = new Operator("<");
    public static final Operator GREATER_THAN = new Operator(">");
    public static final Operator EQUALS = new Operator("=");
    public static final Operator NOT_EQUALS = new Operator("!=");
    public static final Operator IS_NULL = new Operator("IS NULL");
    public static final Operator LIKE = new Operator("LIKE");
    private String operation;
    private int numOperands;

    private Operator(String newOp) {
        this.numOperands = newOp.equals("IS NULL") ? 1 : 2;
        this.operation = newOp;
    }

    public Operator(String newOp, int newNumOperands) {
        this.operation = newOp;
        this.setOperandCount(newNumOperands);
    }

    public void setOperandCount(int newOperands) {
        if (newOperands < 0 || newOperands > 2) {
            throw new IllegalArgumentException("Attempt to set operand count to unsupported number of operands, only unary and binary currently supported");
        }
        this.numOperands = newOperands;
    }

    public int getOperandCount() {
        return this.numOperands;
    }

    @Override
    public String toString() {
        return this.operation;
    }
}

