/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.sql.queries;

import au.com.ordermate.sql.queries.Literal;
import au.com.ordermate.sql.queries.Operator;
import au.com.ordermate.sql.queries.Param;
import au.com.ordermate.sql.queries.SQLColumn;
import au.com.ordermate.sql.queries.Value;
import au.com.ordermate.sql.queries.Where;
import java.util.LinkedHashSet;
import java.util.Set;

public class SQLWhere
extends Where {
    private String clause;
    private Set tables = new LinkedHashSet();

    private SQLWhere() {
    }

    private SQLWhere(SQLColumn left, Operator op) {
        this.clause = left + " " + op;
        this.tables.add(left.getTable());
    }

    private SQLWhere(SQLColumn left, Operator op, SQLColumn right) {
        this.clause = left + " " + op + " " + right;
        this.tables.add(left.getTable());
        this.tables.add(right.getTable());
    }

    private SQLWhere(SQLColumn left, Operator op, Value right) {
        this.clause = left + " " + op + " " + right;
        this.tables.add(left.getTable());
    }

    @Override
    public String toString() {
        return this.clause;
    }

    public Set getTables() {
        return this.tables;
    }

    public static SQLWhere fkLink(String hasIDTable, String hasFKTable) {
        return new SQLWhere(SQLColumn.get(hasIDTable, "ID"), Operator.EQUALS, SQLColumn.get(hasFKTable, "FK_" + hasIDTable));
    }

    public static SQLWhere fkLink(String hasIDTable, String hasFKTable, String FKCol) {
        return new SQLWhere(SQLColumn.get(hasIDTable, "ID"), Operator.EQUALS, SQLColumn.get(hasFKTable, FKCol));
    }

    public static SQLWhere active(String activeTable) {
        return new SQLWhere(SQLColumn.get(activeTable, "system_state"), Operator.EQUALS, Literal.get("'ACTIVE'"));
    }

    public static SQLWhere get(SQLColumn left, Operator op) {
        return new SQLWhere(left, op);
    }

    public static SQLWhere get(SQLColumn left, Operator op, SQLColumn right) {
        return new SQLWhere(left, op, right);
    }

    public static SQLWhere get(SQLColumn left, Operator op, Value right) {
        return new SQLWhere(left, op, right);
    }

    public static SQLWhere equalsParam(String table, String col) {
        return new SQLWhere(SQLColumn.get(table, col), Operator.EQUALS, Param.PARAM);
    }

    public static SQLWhere equalsOrParam(SQLColumn col1, Operator op1, Value val1, SQLColumn col2, Operator op2, Value val2) {
        SQLWhere where = new SQLWhere();
        where.clause = "( " + col1.toString() + " " + op1.toString() + " " + val1.toString() + " OR " + col2.toString() + " " + op2.toString() + " " + val2.toString() + " )";
        where.tables.add(col1.getTable());
        where.tables.add(col2.getTable());
        return where;
    }
}

