/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.sql.queries;

import au.com.ordermate.sql.queries.Operator;
import au.com.ordermate.sql.queries.SQLColumn;
import au.com.ordermate.sql.queries.SQLElement;
import au.com.ordermate.sql.queries.SQLWhere;
import au.com.ordermate.sql.queries.Value;
import au.com.ordermate.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class SelectQuery
extends SQLElement {
    private List<String> selectValues = new ArrayList<String>();
    private Set<String> fromTables = new LinkedHashSet<String>();
    private List<String> where = new ArrayList<String>();
    private List<String> whereNonClearable = new ArrayList<String>();
    private List<String> having = new ArrayList<String>();
    private List<String> orderBy = new ArrayList<String>();
    private List<String> groupBy = new ArrayList<String>();
    private boolean distinct = false;
    private Integer limit = null;
    private Integer offset = null;
    private List<Boolean> order = new ArrayList<Boolean>();

    public SelectQuery() {
    }

    public SelectQuery(SelectQuery q) {
        this.selectValues = new ArrayList<String>(q.selectValues);
        this.fromTables = new LinkedHashSet<String>(q.fromTables);
        this.where = new ArrayList<String>(q.where);
        this.orderBy = new ArrayList<String>(q.orderBy);
        this.order = new ArrayList<Boolean>(q.order);
        this.groupBy = q.groupBy;
    }

    public SelectQuery(String from) {
        this.fromTables.add(from);
    }

    public SelectQuery(String[] from) {
        for (String element : from) {
            this.fromTables.add(element);
        }
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean dist) {
        this.distinct = dist;
    }

    public void addFromTable(String tableName) {
        this.fromTables.add(tableName);
    }

    public void setFromTables(String[] fromTableList) {
        this.fromTables = new LinkedHashSet<String>(Arrays.asList(fromTableList));
    }

    public void addWhere(SQLColumn leftSide, Operator operator) {
        this.addWhere(SQLWhere.get(leftSide, operator));
    }

    public void addWhere(SQLColumn leftSide, Operator operator, SQLColumn rightSide) {
        this.addWhere(SQLWhere.get(leftSide, operator, rightSide));
    }

    public void addWhere(SQLColumn leftSide, Operator operator, Value rightSide) {
        this.addWhere(SQLWhere.get(leftSide, operator, rightSide));
    }

    public void addWhere(SQLWhere toAdd) {
        this.addWhere(toAdd.toString());
        this.fromTables.addAll(toAdd.getTables());
    }

    public void addWhere(String whereCond) {
        if (whereCond.equalsIgnoreCase("")) {
            throw new IllegalArgumentException("Attempt to add empty string as where clause.");
        }
        this.where.add(whereCond);
    }

    public void addImmutableWhere(String whereCond) {
        this.whereNonClearable.add(whereCond);
    }

    public void addImmutableWhere(SQLWhere toAdd) {
        this.addImmutableWhere(toAdd.toString());
        this.fromTables.addAll(toAdd.getTables());
    }

    public void addWhereOr(String[] whereConds) {
        StringBuffer whereString = new StringBuffer("(");
        for (int i = 0; i < whereConds.length; ++i) {
            if (i != 0) {
                whereString.append(" OR");
            }
            whereString.append(" " + whereConds[i]);
        }
        whereString.append(')');
        this.addWhere(whereString.toString());
    }

    public void addHaving(String havingCond) {
        this.having.add(havingCond);
    }

    public void addSelectValue(SQLColumn col) {
        this.addSelectValue(col.toString());
    }

    public void addSelectValue(String value) {
        this.selectValues.add(value);
    }

    public void clearSelectValues() {
        this.selectValues.clear();
    }

    public void addOrderBy(SQLColumn col) {
        this.addOrderBy(col.toString());
    }

    public void addOrderBy(String orderByCond) {
        this.addOrderBy(orderByCond, true);
    }

    public void addOrderBy(SQLColumn col, boolean ascending) {
        this.addOrderBy(col.toString(), ascending);
    }

    public void addOrderBy(String orderByCol, boolean ascending) {
        Boolean val = ascending ? Boolean.TRUE : Boolean.FALSE;
        String unquotedCol = StringUtils.stripQuotes(orderByCol);
        int existingIndex = this.orderBy.indexOf(unquotedCol);
        if (existingIndex == -1) {
            this.orderBy.add(unquotedCol);
            this.order.add(val);
        } else {
            this.order.set(existingIndex, val);
        }
    }

    public void clearWhere() {
        this.where.clear();
    }

    public void clearHaving() {
        this.having.clear();
    }

    public void removeWhere(String whereCond) {
        this.where.remove(whereCond);
    }

    public void removeOrderBy(String column) {
        int index = this.orderBy.indexOf(column);
        if (index != -1) {
            this.order.remove(index);
            this.orderBy.remove(index);
        }
    }

    public void clearOrderBy() {
        this.orderBy.clear();
        this.order.clear();
    }

    public void clearGroupBy() {
        this.groupBy.clear();
    }

    public void addGroupBy(String str) {
        this.groupBy.add(str);
    }

    public List getOrderByList() {
        return Collections.unmodifiableList(this.orderBy);
    }

    public List getOrderModeList() {
        return Collections.unmodifiableList(this.order);
    }

    public Set getFromTables() {
        return this.fromTables;
    }

    public String getSQL() {
        return this.getSQL(true);
    }

    public String getSQL(boolean onOneLine) {
        int i;
        StringBuilder query = new StringBuilder("SELECT ");
        if (this.distinct) {
            query.append("DISTINCT ");
        }
        if (this.selectValues.size() == 0) {
            query.append("* ");
        } else {
            for (int i2 = 0; i2 < this.selectValues.size(); ++i2) {
                if (i2 != 0) {
                    query.append(", ");
                    if (!onOneLine) {
                        query.append("\n\t");
                    }
                }
                query.append(this.selectValues.get(i2));
            }
            query.append(' ');
        }
        if (!onOneLine) {
            query.append('\n');
        }
        query.append("FROM ");
        Iterator<String> it = this.fromTables.iterator();
        while (it.hasNext()) {
            String table = it.next();
            query.append(table + " ");
            if (!it.hasNext()) continue;
            query.append(", ");
            if (onOneLine) continue;
            query.append("\n\t");
        }
        if (!this.where.isEmpty() || !this.whereNonClearable.isEmpty()) {
            int i3;
            if (!onOneLine) {
                query.append('\n');
            }
            query.append("WHERE ");
            for (i3 = 0; i3 < this.where.size(); ++i3) {
                if (i3 != 0) {
                    if (!onOneLine) {
                        query.append('\n');
                    }
                    query.append("AND ");
                }
                query.append(this.where.get(i3) + " ");
            }
            if (!this.where.isEmpty() && !this.whereNonClearable.isEmpty()) {
                if (!onOneLine) {
                    query.append('\n');
                }
                query.append(" AND ");
            }
            for (i3 = 0; i3 < this.whereNonClearable.size(); ++i3) {
                if (i3 != 0) {
                    if (!onOneLine) {
                        query.append('\n');
                    }
                    query.append(" AND ");
                }
                query.append(this.whereNonClearable.get(i3) + " ");
            }
        }
        for (i = 0; i < this.groupBy.size(); ++i) {
            if (i == 0) {
                if (!onOneLine) {
                    query.append('\n');
                }
                query.append("GROUP BY ");
            } else {
                query.append(", ");
            }
            query.append(this.groupBy.get(i) + " ");
        }
        if (!this.having.isEmpty()) {
            if (!onOneLine) {
                query.append('\n');
            }
            query.append("HAVING ");
            for (i = 0; i < this.having.size(); ++i) {
                if (i != 0) {
                    if (!onOneLine) {
                        query.append('\n');
                    }
                    query.append("AND ");
                }
                query.append(this.having.get(i) + " ");
            }
        }
        for (i = 0; i < this.orderBy.size(); ++i) {
            if (i == 0) {
                if (!onOneLine) {
                    query.append('\n');
                }
                query.append("ORDER BY ");
            } else {
                query.append(", ");
            }
            Boolean asc = this.order.get(i);
            query.append(StringUtils.escapeSQLColumnName(this.orderBy.get(i))).append(" ").append(asc != false ? "ASC " : "DESC ");
        }
        if (this.limit != null) {
            String offsetString = "";
            if (this.offset != null) {
                offsetString = this.offset.toString() + ",";
            }
            query.append(" LIMIT " + offsetString + this.limit.toString() + " ");
        }
        return query.toString();
    }

    @Override
    public String toString() {
        return this.getSQL();
    }

    public void addLimit(int newLimit) {
        this.addLimit(newLimit, 0);
    }

    public void addLimit(int newLimit, int newOffset) {
        this.limit = newLimit;
        this.offset = newOffset;
    }

    public void removeLimit() {
        this.limit = null;
        this.offset = null;
    }
}

