/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.unique;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.simplermi.SimpleRMI;
import au.com.ordermate.unique.RemoteUnique;
import au.com.ordermate.unique.RemoteUniqueImpl;
import au.com.ordermate.unique.Service;
import au.com.ordermate.unique.StringService;
import java.net.InetAddress;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;

public class Unique {
    private static RemoteUniqueImpl registry;
    private static boolean registryStarted;

    private Unique() {
    }

    public static boolean registerService(String serviceName) throws RemoteException {
        return Unique.registerService(new StringService(serviceName));
    }

    public static synchronized boolean registerService(Service service) throws RemoteException {
        if (!registryStarted) {
            registry = new RemoteUniqueImpl();
            if (!registry.equals(SimpleRMI.shareObject(registry, "UniqueService" + service.toString()))) {
                return false;
            }
            registryStarted = true;
        }
        registry.registerService(service);
        return true;
    }

    public static synchronized boolean isServiceRunning(InetAddress hostAddress, String serviceName, int port) {
        boolean running;
        RemoteUnique remote;
        try {
            remote = (RemoteUnique)SimpleRMI.getObject(hostAddress, "UniqueService" + serviceName.toString(), port);
        }
        catch (RemoteException e) {
            return false;
        }
        catch (NotBoundException e) {
            return false;
        }
        try {
            running = remote.serviceRunning(serviceName);
        }
        catch (RemoteException e) {
            OrderMateLog.LOG.warn("Error while trying to query remote unique service. Service is assumed to be running.", (Throwable)e);
            return true;
        }
        return running;
    }

    public static synchronized void shutdown(String service) {
        if (registryStarted) {
            SimpleRMI.unshareObject("UniqueService" + service);
            registry = null;
        }
        registryStarted = false;
    }

    static {
        registryStarted = false;
    }
}

