/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.units;

import au.com.ordermate.OrderMateLog;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import javax.persistence.Embeddable;
import org.hibernate.annotations.AccessType;

@Embeddable
@AccessType(value="field")
public class SalesQuantity
implements Comparable,
Serializable {
    public static final SalesQuantity ZERO = new SalesQuantity(BigDecimal.ZERO);
    public static final SalesQuantity ONE = new SalesQuantity(BigDecimal.ONE);
    public static final SalesQuantity TEN = new SalesQuantity(BigDecimal.TEN);
    private static final SalesQuantity[] quantityCache = new SalesQuantity[]{ZERO, ONE, new SalesQuantity(BigDecimal.valueOf(2L)), new SalesQuantity(BigDecimal.valueOf(3L)), new SalesQuantity(BigDecimal.valueOf(4L)), new SalesQuantity(BigDecimal.valueOf(5L)), new SalesQuantity(BigDecimal.valueOf(6L)), new SalesQuantity(BigDecimal.valueOf(7L)), new SalesQuantity(BigDecimal.valueOf(8L)), new SalesQuantity(BigDecimal.valueOf(9L)), TEN};
    private static final int DIVISOR_SCALE = 20;
    private static int NUM_DISPLAYED_DECIMAL_PLACES = 3;
    private static final NumberFormat QTY_FORMAT = NumberFormat.getInstance();
    private static final NumberFormat WEIGHT_QTY_FORMAT;
    private BigDecimal number;

    protected SalesQuantity() {
    }

    public SalesQuantity(BigDecimal amount) {
        if (amount == null) {
            OrderMateLog.LOG.warn("Initializing SalesQuantity with null amount", (Throwable)new Exception());
        }
        this.number = amount;
    }

    public static SalesQuantity valueOf(long amount) {
        if (amount >= 0L && amount < (long)(quantityCache.length - 1)) {
            return quantityCache[(int)amount];
        }
        return new SalesQuantity(BigDecimal.valueOf(amount));
    }

    public static SalesQuantity valueOf(String strValue) {
        return new SalesQuantity(strValue);
    }

    public BigDecimal getValue() {
        return this.number;
    }

    public SalesQuantity(String amount) {
        this(new BigDecimal(amount));
    }

    public SalesQuantity add(SalesQuantity quantity) {
        return new SalesQuantity(quantity.number.add(this.number));
    }

    public SalesQuantity subtract(SalesQuantity quantity) {
        return new SalesQuantity(this.number.subtract(quantity.number));
    }

    public SalesQuantity multiply(SalesQuantity quantity) {
        return new SalesQuantity(this.number.multiply(quantity.number));
    }

    public SalesQuantity divide(SalesQuantity quantity) {
        return new SalesQuantity(this.number.divide(quantity.number, 20, RoundingMode.HALF_EVEN));
    }

    public SalesQuantity negate() {
        return new SalesQuantity(this.number.negate());
    }

    public String toString() {
        return QTY_FORMAT.format(this.number);
    }

    public String weightedQtyToString() {
        return WEIGHT_QTY_FORMAT.format(this.number);
    }

    public boolean greaterThan(long compareTo) {
        return this.greaterThan(SalesQuantity.valueOf(compareTo));
    }

    public boolean greaterThan(SalesQuantity compareTo) {
        return this.compareTo(compareTo) > 0;
    }

    public boolean lessThan(long compareTo) {
        return this.lessThan(SalesQuantity.valueOf(compareTo));
    }

    public boolean lessThan(SalesQuantity compareTo) {
        return this.compareTo(compareTo) < 0;
    }

    public boolean lessThanOrEquals(long compareTo) {
        return this.lessThanOrEquals(SalesQuantity.valueOf(compareTo));
    }

    public boolean lessThanOrEquals(SalesQuantity compareTo) {
        return this.lessThan(compareTo) || this.equals(compareTo);
    }

    public boolean greaterThanOrEquals(SalesQuantity compareTo) {
        return this.greaterThan(compareTo) || this.equals(compareTo);
    }

    public boolean greaterThanOrEquals(long compareTo) {
        return this.greaterThanOrEquals(SalesQuantity.valueOf(compareTo));
    }

    public boolean equals(long compareTo) {
        return this.equals(SalesQuantity.valueOf(compareTo));
    }

    public boolean equals(SalesQuantity compareTo) {
        return this.compareTo(compareTo) == 0;
    }

    public boolean equals(Object object) {
        if (object instanceof SalesQuantity) {
            return this.equals((SalesQuantity)object);
        }
        if (object instanceof Integer || object instanceof Long) {
            return this.equals(((Number)object).longValue());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean notEquals(int compareTo) {
        return !this.equals(compareTo);
    }

    public boolean notEquals(SalesQuantity compareTo) {
        return !this.equals(compareTo);
    }

    public int compareTo(Object compareTo) {
        SalesQuantity quantityToCompare;
        if (compareTo instanceof SalesQuantity) {
            quantityToCompare = (SalesQuantity)compareTo;
        } else if (compareTo instanceof Integer || compareTo instanceof Long) {
            quantityToCompare = SalesQuantity.valueOf(((Integer)compareTo).longValue());
        } else {
            if (compareTo != null) {
                throw new IllegalArgumentException(compareTo + " is not instance of SalesQuantity is " + compareTo != null ? compareTo.getClass().getSimpleName() : " null");
            }
            throw new IllegalArgumentException("Attempting to compare null to " + this);
        }
        return this.compareTo(quantityToCompare);
    }

    public int compareTo(SalesQuantity compareTo) {
        return this.number.compareTo(compareTo.number);
    }

    public SalesQuantity min(SalesQuantity other) {
        return new SalesQuantity(this.number.min(other.number));
    }

    public SalesQuantity max(SalesQuantity other) {
        return new SalesQuantity(this.number.max(other.number));
    }

    static {
        QTY_FORMAT.setMaximumFractionDigits(NUM_DISPLAYED_DECIMAL_PLACES);
        QTY_FORMAT.setMinimumFractionDigits(0);
        WEIGHT_QTY_FORMAT = NumberFormat.getInstance();
        WEIGHT_QTY_FORMAT.setMaximumFractionDigits(NUM_DISPLAYED_DECIMAL_PLACES);
        WEIGHT_QTY_FORMAT.setMinimumFractionDigits(NUM_DISPLAYED_DECIMAL_PLACES);
    }
}

