/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.util.AssertionFailedException;

public final class Assert {
    private static boolean throwsExceptions = true;

    public static void setThrowsExceptions(boolean b) {
        throwsExceptions = b;
    }

    public static boolean throwsExceptions() {
        return throwsExceptions;
    }

    public static void isInstanceOf(Object o, Class cls, String message) {
        Class<?> objClass;
        Class<?> clazz = objClass = o != null ? o.getClass() : null;
        if (o == null || !cls.isAssignableFrom(objClass)) {
            Assert.handleFailEqualsAssert(cls, objClass, message);
        }
    }

    public static void isTrue(boolean cond, String message) {
        if (!cond) {
            Assert.handleFailSimpleAssert(message);
        }
    }

    public static void isFalse(boolean cond, String message) {
        Assert.isTrue(!cond, message);
    }

    public static void isEqual(Object expected, Object actual, String message) {
        if (!(expected == null && actual == null || actual != null && actual.equals(expected))) {
            Assert.handleFailEqualsAssert(expected, actual, message);
        }
    }

    public static void isEqual(int expected, int actual, String message) {
        Assert.isEqual((Object)expected, (Object)actual, message);
    }

    public static void isEqual(double a, double b, String message) {
        Assert.isEqual(new Double(a), new Double(b), message);
    }

    public static void isEqual(char a, char b, String message) {
        Assert.isEqual(Character.valueOf(a), Character.valueOf(b), message);
    }

    public static void isEqual(long a, long b, String message) {
        Assert.isEqual((Object)a, (Object)b, message);
    }

    public static void isNull(Object obj, String message) {
        Assert.isEqual(obj, null, message);
    }

    public static void isNotNull(Object obj, String message) {
        Assert.isTrue(obj != null, message);
    }

    private static void handleFailSimpleAssert(String message) {
        AssertionFailedException e = new AssertionFailedException(message);
        Assert.handleFailure(e);
    }

    private static void handleFailEqualsAssert(Object expected, Object actual, String message) {
        AssertionFailedException e = new AssertionFailedException(message + "\nExpected: <" + expected + "> \nActual: <" + actual + ">");
        Assert.handleFailure(e);
    }

    private static void handleFailure(AssertionFailedException e) {
        if (throwsExceptions) {
            throw e;
        }
        OrderMateLog.LOG.error(e.getMessage(), (Throwable)e);
    }

    private Assert() {
    }
}

