/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util;

import au.com.ordermate.util.ReportRangeType;
import au.com.ordermate.util.TimeLength;
import java.sql.Time;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ordermate.OrderMate;
import ordermate.database.misc.BusinessInfo;

public class DateTimeUtils {
    private static final ThreadLocalDateFormat DATE_FORMAT_CACHE = new ThreadLocalDateFormat(new SimpleDateFormat("dd/MM/yy hh:mm a"));
    private static final ThreadLocalDateFormat MEDIUM_CACHE = new ThreadLocalDateFormat(DateFormat.getDateInstance(2));
    private static final ThreadLocalDateFormat SHORT_CACHE = new ThreadLocalDateFormat(DateFormat.getDateInstance(3));
    private static final ThreadLocalDateFormat VERY_SHORT_CACHE = new ThreadLocalDateFormat(new SimpleDateFormat("dd/MM"));
    private static final ThreadLocalDateFormat SIMPLE_TIME_FORMAT = new ThreadLocalDateFormat(new SimpleDateFormat("h:mm a"));
    private static final ThreadLocalDateFormat DAY_OF_WEEK = new ThreadLocalDateFormat(new SimpleDateFormat("E"));
    private final ThreadLocalDateFormat DOCKET_12H_CACHE = SIMPLE_TIME_FORMAT;
    private final ThreadLocalDateFormat DOCKET_24H_CACHE = new ThreadLocalDateFormat(new SimpleDateFormat("HH:mm"));
    private static final ThreadLocalDateFormat LONG_CACHE = new ThreadLocalDateFormat(new SimpleDateFormat("EEE, MMM dd yyyy"));
    private static final ThreadLocalDateFormat SQL_DATE_FORMAT = new ThreadLocalDateFormat(new SimpleDateFormat("yyyy-MM-dd"));
    private static final ThreadLocalDateFormat SQL_TIMESTAMP_FORMAT = new ThreadLocalDateFormat(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    private static final ThreadLocalDateFormat SQL_TIME_FORMAT = new ThreadLocalDateFormat(new SimpleDateFormat("HH:mm:ss"));
    private static final ThreadLocalDateFormat LONG_DATE_FORMAT = new ThreadLocalDateFormat(new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy"));
    private static final ThreadLocalDateFormat BASIC_DATE_FORMAT = new ThreadLocalDateFormat(new SimpleDateFormat("yyyyMMdd"));
    private static final ThreadLocalDateFormat DETAILED_DATE_FORMAT = new ThreadLocalDateFormat(new SimpleDateFormat("yyyyMMddhhmmss"));
    private static final ThreadLocalDateFormat DATE_OF_BIRTH_FORMAT = new ThreadLocalDateFormat(new SimpleDateFormat("dd/MM/yyyy"));
    private static final ThreadLocalDateFormat CONSISTENT_REPORT_FORMAT = new ThreadLocalDateFormat(new SimpleDateFormat("dd/MM/yyyy hh:mm:ss aaa"));
    private static final ThreadLocalDateFormat CONSISTENT_24_HOUR_REPORT_FORMAT = new ThreadLocalDateFormat(new SimpleDateFormat("dd/MM/yyyy HH:mm:ss"));
    public static final String ISO8601_UTC_DateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    public static final long MILLISEC_PER_SECOND = 1000L;
    public static final long MILLISEC_PER_MINUTE = 60000L;
    public static final long MILLISEC_PER_HOUR = 3600000L;
    public static final long MILLISEC_PER_DAY = 86400000L;
    public static final int SEC_PER_DAY = 86400;
    public static final Date MINIMUM_DATE = new Date(0L);
    private static int currentYear = 0;
    private static DateTimeUtils instance = new DateTimeUtils();
    public static final List<String> monthsAbbreviated = Arrays.asList("Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec");
    public static final List<String> daysOfMonth = Arrays.asList("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31");
    public static final int MONDAY = 1;
    public static final int TUESDAY = 2;
    public static final int WEDNESDAY = 3;
    public static final int THURSDAY = 4;
    public static final int FRIDAY = 5;
    public static final int SATURDAY = 6;
    public static final int SUNDAY = 7;
    private static final long MillisInAnHr = 3600000L;

    public static String formatDateForDisplay(String theDate) {
        StringTokenizer s = new StringTokenizer(theDate, " ");
        String returnString = "";
        if (s.countTokens() == 6) {
            returnString = returnString + s.nextToken() + " ";
            returnString = returnString + s.nextToken() + " ";
            returnString = returnString + s.nextToken() + " ";
            s.nextToken();
            s.nextToken();
            returnString = returnString + s.nextToken();
            return returnString;
        }
        return "Invalid date";
    }

    public static String formatDateForDisplay(Date theDate) {
        if (theDate == null) {
            return null;
        }
        return DateTimeUtils.getDateTimeFormat().format(theDate);
    }

    public static String formatTimeForDisplay(Time theTime) {
        if (theTime != null) {
            return DateTimeUtils.formatTimeForDisplay(new Date(theTime.getTime()));
        }
        return null;
    }

    public static String formatTimeForDisplay(Date theTime) {
        if (theTime == null) {
            return null;
        }
        if (BusinessInfo.getInstance().getDocketHourFormat().equals("12h")) {
            return instance.getDocket12HFormat().format(theTime);
        }
        return instance.getDocket24HFormat().format(theTime);
    }

    public static List<String> getPreviousDateRange(Date startDate, Date endDate, ReportRangeType rangeType) {
        ArrayList<String> dateRange = new ArrayList<String>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        Date startDateRange = startDate;
        while (startDateRange.before(endDate)) {
            calendar.add(rangeType.getCalendarField(), 1);
            calendar.add(5, -1);
            Date endDateRange = calendar.getTime();
            dateRange.add(DateTimeUtils.getStringRange(startDateRange, endDateRange));
            calendar.setTime(endDateRange);
            calendar.add(5, 1);
            startDateRange = calendar.getTime();
        }
        return dateRange;
    }

    private static String getStringRange(Date startRange, Date endRange) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
        String dateRange = String.format("%s - %s", simpleDateFormat.format(startRange), simpleDateFormat.format(endRange));
        return dateRange;
    }

    public static String toMonthInt(String string) {
        for (int i = 0; i < monthsAbbreviated.size(); ++i) {
            if (!monthsAbbreviated.get(i).equalsIgnoreCase(string)) continue;
            if (i < 9) {
                return "0" + (i + 1);
            }
            return i + 1 + "";
        }
        return string;
    }

    public static String convertToTwelveHourTime(Date theTime) {
        Time time = new Time(theTime.getTime());
        return DateTimeUtils.convertToTwelveHourTime(time);
    }

    public static String convertToTwelveHourTime(Time theTime) {
        StringTokenizer s = new StringTokenizer(theTime.toString(), ":");
        String fillerZero = "0";
        if (s.countTokens() == 3) {
            String amPm;
            int minutes;
            int hours;
            try {
                hours = Integer.parseInt(s.nextToken());
                minutes = Integer.parseInt(s.nextToken());
                amPm = hours >= 12 ? "PM" : "AM";
                if (hours > 12) {
                    hours -= 12;
                }
                if (hours == 0) {
                    hours = 12;
                }
                if (minutes > 9) {
                    fillerZero = "";
                }
            }
            catch (NumberFormatException e) {
                return theTime.toString();
            }
            String returnString = hours + ":" + fillerZero + minutes + " " + amPm;
            return returnString;
        }
        return null;
    }

    public static String getHoursFromTime(Time theTime) {
        String convertedTime = DateTimeUtils.convertToTwelveHourTime(theTime);
        StringTokenizer s = new StringTokenizer(convertedTime, " :");
        if (s.countTokens() == 3) {
            return s.nextToken();
        }
        return "-1";
    }

    public static String getMinutesFromTime(Time theTime) {
        String convertedTime = DateTimeUtils.convertToTwelveHourTime(theTime);
        StringTokenizer s = new StringTokenizer(convertedTime, " :");
        if (s.countTokens() == 3) {
            s.nextToken();
            return s.nextToken();
        }
        return "-1";
    }

    public static String amOrPm(Time theTime) {
        StringTokenizer s = new StringTokenizer(theTime.toString(), ":");
        String amPm = "AM";
        if (s.countTokens() == 3) {
            try {
                int hours = Integer.parseInt(s.nextToken());
                amPm = hours > 11 ? "PM" : "AM";
            }
            catch (NumberFormatException e) {
                return "ERROR";
            }
            return amPm;
        }
        return "ERROR";
    }

    public static String getTimeStamp() {
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        String DATE_FORMAT = "dd/MM/yyyy HH:mm:ss";
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        sdf.setTimeZone(TimeZone.getDefault());
        return sdf.format(cal.getTime());
    }

    public static boolean dateIsBeforeToday(Date theDate) {
        GregorianCalendar theCalendar = new GregorianCalendar();
        theCalendar.setTime(theDate);
        GregorianCalendar systemDate = new GregorianCalendar();
        systemDate.setTime(new Date(System.currentTimeMillis()));
        boolean enable = theCalendar.get(1) < systemDate.get(1) ? true : theCalendar.get(6) < systemDate.get(6) && theCalendar.get(1) <= systemDate.get(1);
        return enable;
    }

    public static boolean dateIsAfterToday(Date theDate) {
        GregorianCalendar theCalendar = new GregorianCalendar();
        theCalendar.setTime(theDate);
        GregorianCalendar systemDate = new GregorianCalendar();
        systemDate.setTime(new Date(System.currentTimeMillis()));
        boolean enable = theCalendar.get(1) > systemDate.get(1) ? true : theCalendar.get(6) > systemDate.get(6) && theCalendar.get(1) >= systemDate.get(1);
        return enable;
    }

    public static boolean dateIsToday(Date theDate) {
        GregorianCalendar theCalendar = new GregorianCalendar();
        theCalendar.setTime(theDate);
        GregorianCalendar systemDate = new GregorianCalendar();
        systemDate.setTime(new Date(System.currentTimeMillis()));
        boolean enable = false;
        if (theCalendar.get(1) == systemDate.get(1) && theCalendar.get(6) == systemDate.get(6)) {
            enable = true;
        }
        return enable;
    }

    public static String[] getYears(int numYears) {
        GregorianCalendar systemDate = new GregorianCalendar();
        systemDate.setTime(new Date(System.currentTimeMillis()));
        int currentYear = systemDate.get(1) - 10;
        String[] years = new String[numYears];
        for (int i = 0; i < years.length; ++i) {
            years[i] = "" + (currentYear - i);
        }
        return years;
    }

    public static Calendar getEndOfDay(Calendar cal) {
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal;
    }

    public static Date getEndOfDay(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        DateTimeUtils.getEndOfDay(cal);
        return cal.getTime();
    }

    public static Date getEndOfHour(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    public static Date getStartOfDay(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getStartOfHour(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.getTime();
    }

    public static boolean timeIsWithinDuration(Date toCompare, Date startDate, long duration) {
        if (duration > 86400000L) {
            return true;
        }
        Calendar toCompareAsCal = Calendar.getInstance();
        toCompareAsCal.setTime(toCompare);
        Calendar startDateAsCal = Calendar.getInstance();
        startDateAsCal.setTime(startDate);
        Calendar compareCal = Calendar.getInstance();
        compareCal.clear();
        compareCal.set(11, toCompareAsCal.get(11));
        compareCal.set(12, toCompareAsCal.get(12));
        Calendar startCal = Calendar.getInstance();
        startCal.clear();
        startCal.set(11, startDateAsCal.get(11));
        startCal.set(12, startDateAsCal.get(12));
        long compareTime = compareCal.getTimeInMillis();
        long startTime = startCal.getTimeInMillis();
        if (compareTime < startTime) {
            compareTime += 86400000L;
        }
        if (compareTime == startTime) {
            return true;
        }
        if (compareTime < startTime) {
            return false;
        }
        return compareTime - duration < startTime;
    }

    public static boolean timeIsBefore(Date small, Date large) {
        int afterMillisecond;
        int afterSecond;
        int afterMinute;
        Calendar beforeCal = Calendar.getInstance();
        beforeCal.setTime(small);
        Calendar afterCal = Calendar.getInstance();
        afterCal.setTime(large);
        int beforeHourOfDay = beforeCal.get(11);
        int afterHourOfDay = afterCal.get(11);
        if (beforeHourOfDay < afterHourOfDay) {
            return true;
        }
        if (beforeHourOfDay > afterHourOfDay) {
            return false;
        }
        int beforeMinute = beforeCal.get(12);
        if (beforeMinute < (afterMinute = afterCal.get(12))) {
            return true;
        }
        if (beforeMinute > afterMinute) {
            return false;
        }
        int beforeSecond = beforeCal.get(13);
        if (beforeSecond < (afterSecond = afterCal.get(13))) {
            return true;
        }
        if (beforeSecond > afterSecond) {
            return false;
        }
        int beforeMillisecond = beforeCal.get(14);
        return beforeMillisecond < (afterMillisecond = afterCal.get(14));
    }

    public static boolean timeIsEqual(Date first, Date second) {
        Calendar firstCal = Calendar.getInstance();
        firstCal.setTime(first);
        int firstHourOfDay = firstCal.get(11);
        int firstMinute = firstCal.get(12);
        int firstSecond = firstCal.get(13);
        int firstMillisecond = firstCal.get(14);
        Calendar secondCal = Calendar.getInstance();
        secondCal.setTime(second);
        int secondHourOfDay = secondCal.get(11);
        int secondMinute = secondCal.get(12);
        int secondSecond = secondCal.get(13);
        int secondMillisecond = secondCal.get(14);
        return firstHourOfDay == secondHourOfDay && firstMinute == secondMinute && firstSecond == secondSecond && firstMillisecond == secondMillisecond;
    }

    public static boolean timeIsAfter(Date large, Date small) {
        return !DateTimeUtils.timeIsBefore(large, small) && !DateTimeUtils.timeIsEqual(small, large);
    }

    public static Date mergeDateAndTime(Date date, Date time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        Calendar timeCal = Calendar.getInstance();
        timeCal.setTime(time);
        cal.set(11, timeCal.get(11));
        cal.set(12, timeCal.get(12));
        cal.set(13, timeCal.get(13));
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getThreeMonthsAgo() {
        return DateTimeUtils.getThreeMonthsAgoCal().getTime();
    }

    public static Calendar getOneMonthAgoCal() {
        Calendar cal = Calendar.getInstance();
        cal.add(2, -1);
        return cal;
    }

    public static Calendar getStartOfMonth(Date value) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(value);
        cal.set(5, 1);
        DateTimeUtils.clearTimePart(cal);
        return cal;
    }

    public static Calendar getStartOfYear(Date value) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(value);
        cal.set(6, 1);
        DateTimeUtils.clearTimePart(cal);
        return cal;
    }

    public static Calendar getStartOfFinancialYear(Date value) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(value);
        if (cal.get(2) < 6) {
            cal.add(1, -1);
        }
        cal.set(2, 6);
        cal.set(5, 1);
        DateTimeUtils.clearTimePart(cal);
        return cal;
    }

    public static Calendar getEndOfFinancialYear(Date value) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(value);
        if (cal.get(2) >= 6) {
            cal.add(1, 1);
        }
        cal.set(2, 5);
        cal.set(5, 30);
        return DateTimeUtils.getEndOfDay(cal);
    }

    public static Calendar getThreeMonthsAgoCal() {
        Calendar cal = Calendar.getInstance();
        cal.add(2, -3);
        return cal;
    }

    public static Calendar getMonthsAgoOrFutureCal(Date referenceDate, int months) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(referenceDate);
        cal.add(2, months);
        return cal;
    }

    public static Calendar getTwelveMonthsAgoCal() {
        Calendar cal = Calendar.getInstance();
        cal.add(2, -12);
        return cal;
    }

    public static Date getTwelveMonthsAgo() {
        return DateTimeUtils.getTwelveMonthsAgoCal().getTime();
    }

    public static Date[] getMonthlyDateRange(int year, int month) {
        Date[] range = new Date[2];
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(year, month, 1, 0, 0, 0);
        range[0] = cal.getTime();
        cal.set(5, cal.getActualMaximum(5));
        cal.set(11, cal.getActualMaximum(11));
        cal.set(12, cal.getActualMaximum(12));
        cal.set(13, cal.getActualMaximum(13));
        range[1] = cal.getTime();
        return range;
    }

    public static Calendar getEndOfPreviousMonth(Date date) {
        Calendar value = Calendar.getInstance();
        value.setTime(date);
        value.add(2, -1);
        value = DateTimeUtils.getEndOfMonth(value.getTime());
        return value;
    }

    public static Calendar getEndOfMonth(Date date) {
        Calendar value = Calendar.getInstance();
        value.setTime(date);
        value.set(5, value.getActualMaximum(5));
        value.set(11, value.getActualMaximum(11));
        value.set(12, value.getActualMaximum(12));
        value.set(13, value.getActualMaximum(13));
        return value;
    }

    public static DateFormat getDateTimeFormat() {
        return DATE_FORMAT_CACHE.getFormat();
    }

    public static DateFormat getMediumDateFormat() {
        return MEDIUM_CACHE.getFormat();
    }

    public static DateFormat getDateMonthYearFormat() {
        return new SimpleDateFormat("dd/MM/yyyy");
    }

    public static DateFormat getShortDateFormat() {
        return SHORT_CACHE.getFormat();
    }

    public static DateFormat getVeryShortDateFormat() {
        return VERY_SHORT_CACHE.getFormat();
    }

    public DateFormat getDocket12HFormat() {
        return this.DOCKET_12H_CACHE.getFormat();
    }

    public DateFormat getDocket24HFormat() {
        return DateTimeUtils.instance.DOCKET_24H_CACHE.getFormat();
    }

    public static DateFormat get24HFormat() {
        return DateTimeUtils.instance.DOCKET_24H_CACHE.getFormat();
    }

    public static DateFormat getLongFormat() {
        return LONG_CACHE.getFormat();
    }

    public static DateFormat getSimpleTimeFormat() {
        return SIMPLE_TIME_FORMAT.getFormat();
    }

    public static DateFormat getDayOfWeekFormat() {
        return DAY_OF_WEEK.getFormat();
    }

    public static Time longDurationToTime(long duration) {
        return new Time(duration - (long)Calendar.getInstance().getTimeZone().getRawOffset());
    }

    public static long timeDurationToLong(Time time) {
        return time.getTime() + (long)Calendar.getInstance().getTimeZone().getRawOffset();
    }

    public static Date cleanDatePart(Date time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        DateTimeUtils.cleanDatePart(cal);
        return cal.getTime();
    }

    public static Date cleanDatePart(Date time, boolean keepSecondPart) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        DateTimeUtils.cleanDatePart(cal, keepSecondPart);
        return cal.getTime();
    }

    public static Calendar cleanDatePart(Calendar cal) {
        cal.clear(1);
        cal.clear(2);
        cal.clear(5);
        cal.clear(13);
        cal.clear(14);
        return cal;
    }

    public static Calendar cleanDatePart(Calendar cal, boolean keepSecondPart) {
        cal.clear(1);
        cal.clear(2);
        cal.clear(5);
        if (!keepSecondPart) {
            cal.clear(13);
            cal.clear(14);
        }
        return cal;
    }

    public static Date clearTimePart(Date time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        DateTimeUtils.clearTimePart(cal);
        return cal.getTime();
    }

    public static void clearTimePart(Calendar calendarToClear) {
        calendarToClear.set(11, 0);
        calendarToClear.set(12, 0);
        calendarToClear.set(13, 0);
        calendarToClear.set(14, 0);
        calendarToClear.getTime();
    }

    public static Calendar lastMillisecond(Calendar calendar) {
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        calendar.getTime();
        return calendar;
    }

    public static Date clearSeconds(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.clear(13);
        cal.clear(14);
        return cal.getTime();
    }

    public static Date clearMillis(Date currentDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(currentDate);
        cal.clear(14);
        return cal.getTime();
    }

    public static Calendar toCal(Date date) {
        if (date == null) {
            return null;
        }
        Calendar result = Calendar.getInstance();
        result.setTime(date);
        result.getTime();
        return result;
    }

    public static Calendar getCalendar(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    public static long getDifferenceInMillisecs(Date startDate, Date endDate) {
        return endDate.getTime() - startDate.getTime();
    }

    public static String getHoursMinutesForPeriod(long period) {
        return DateTimeUtils.getHoursMinutesSecondsForPeriod(period, "%02d:%02d");
    }

    public static String getHoursMinutesSecondsForPeriod(long period) {
        return DateTimeUtils.getHoursMinutesSecondsForPeriod(period, "%02d:%02d:%02d");
    }

    private static String getHoursMinutesSecondsForPeriod(long period, String format) {
        long diffSeconds = period / 1000L % 60L;
        long diffMinutes = period / 60000L % 60L;
        long diffHours = period / 3600000L;
        return String.format(format, diffHours, diffMinutes, diffSeconds);
    }

    public static Date getStartDateForThisWeek() {
        Calendar cal = Calendar.getInstance();
        return DateTimeUtils.getStartDateForWeek(cal.getTime());
    }

    public static Date getStartDateForLastWeek() {
        Calendar cal = Calendar.getInstance();
        cal.add(7, -7);
        return DateTimeUtils.getStartDateForWeek(cal.getTime());
    }

    public static Date getStartDateForWeek(Date dayOfWeek) {
        Calendar calNow = DateTimeUtils.getCalendar(dayOfWeek);
        switch (calNow.get(7)) {
            case 1: {
                calNow.add(5, -6);
                break;
            }
            case 2: {
                break;
            }
            default: {
                calNow.add(5, -(calNow.get(7) - 2));
            }
        }
        return DateTimeUtils.getStartOfDay(calNow.getTime());
    }

    public static Date getEndDateForWeek(Date dayOfWeek) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateTimeUtils.getStartDateForWeek(dayOfWeek));
        cal.add(7, 6);
        return cal.getTime();
    }

    public static int getCurrentYear() {
        if (currentYear == 0) {
            Calendar cal = Calendar.getInstance();
            currentYear = cal.get(1);
        }
        return currentYear;
    }

    public static String toHoursMinutes(long l) {
        TimeLength hrMin = new TimeLength(l);
        hrMin.setSequence(TimeLength.TimeParams.HOURS, TimeLength.TimeParams.MINUTES);
        hrMin.setParamFormat(TimeLength.TimeParams.HOURS, ":");
        hrMin.setLeadingZeros(TimeLength.TimeParams.MINUTES, true);
        hrMin.setShowZeroFields(true);
        return hrMin.toString();
    }

    public static String toMinutesSeconds(long l) {
        TimeLength minSec = new TimeLength(l);
        minSec.setSequence(TimeLength.TimeParams.MINUTES, TimeLength.TimeParams.SECONDS);
        minSec.setParamFormat(TimeLength.TimeParams.MINUTES, ":");
        minSec.setLeadingZeros(TimeLength.TimeParams.MINUTES, true);
        minSec.setLeadingZeros(TimeLength.TimeParams.SECONDS, true);
        minSec.setShowZeroFields(true);
        return minSec.toString();
    }

    public static Date convertToTimeZoneRetainFields(long millisToParse, TimeZone zoneMillisIsFrom, TimeZone toConvertTo) {
        long newMillis = millisToParse;
        newMillis = millisToParse + (long)(zoneMillisIsFrom.getOffset(millisToParse) - toConvertTo.getOffset(millisToParse));
        return new Date(newMillis);
    }

    public static Date parseDateStringIntoLocalDate(String timeToParse) {
        String JSONDateToMilliseconds = "\\/(Date\\((.*?)([\\+\\-].*)?\\))\\/";
        Pattern pattern = Pattern.compile(JSONDateToMilliseconds);
        Matcher matcher = pattern.matcher(timeToParse.toString());
        String result = matcher.replaceAll("$2");
        long timeInMillis = 0L;
        try {
            timeInMillis = new Long(result);
        }
        catch (Exception e) {
            OrderMate.LOG.debug("Invalid date format! ", (Throwable)e);
            return null;
        }
        return DateTimeUtils.convertToTimeZoneRetainFields(timeInMillis, TimeZone.getTimeZone("GMT"), Calendar.getInstance().getTimeZone());
    }

    public static String buildDateString(Date theDate, TimeZone tz) {
        long millis = theDate.getTime();
        int tzOffset = DateTimeUtils.convertMillisToHours(tz.getOffset(millis));
        StringBuilder sb = new StringBuilder();
        millis += (long)(Calendar.getInstance().getTimeZone().getOffset(millis) - TimeZone.getTimeZone("GMT").getOffset(millis));
        sb.append("/Date(").append(millis);
        if (tzOffset < 0) {
            sb.append("-");
        } else {
            sb.append("+");
        }
        if (tzOffset < 10 && tzOffset > -10) {
            sb.append("0");
        }
        sb.append(Math.abs(tzOffset)).append("00)/");
        return sb.toString();
    }

    public static String buildDateString(Date date) {
        long millis = date.getTime();
        StringBuilder sb = new StringBuilder();
        millis += (long)(Calendar.getInstance().getTimeZone().getOffset(millis) - TimeZone.getTimeZone("GMT").getOffset(millis));
        sb.append("/Date(").append(millis).append(")/");
        return sb.toString();
    }

    private static int convertMillisToHours(long millis) {
        return (int)(millis / 3600000L);
    }

    public static Date combineDateAndTime(Date date, Date time) {
        Calendar dateCal = Calendar.getInstance();
        if (date != null) {
            dateCal.setTime(date);
        }
        Calendar timeCal = Calendar.getInstance();
        timeCal.setTime(time);
        dateCal.set(11, timeCal.get(11));
        dateCal.set(12, timeCal.get(12));
        dateCal.set(13, timeCal.get(13));
        dateCal.set(14, timeCal.get(14));
        return dateCal.getTime();
    }

    public static List<Date> getDaysBetween(Date from, Date to) {
        if (from == null || to == null) {
            throw new IllegalArgumentException("Cannot make a date list with an invalid range");
        }
        if (!from.before(to)) {
            throw new IllegalArgumentException("From must come before to to make a date range.");
        }
        Calendar cal = DateTimeUtils.toCal(DateTimeUtils.clearTimePart(from));
        ArrayList<Date> dates = new ArrayList<Date>();
        Date nextTime = cal.getTime();
        while (nextTime.before(to) || nextTime.equals(to)) {
            dates.add(nextTime);
            cal.add(5, 1);
            nextTime = cal.getTime();
        }
        return dates;
    }

    public static int getWeekOfYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(3);
    }

    public static void configCalendarWeekDetails(Calendar cal, int firstDayOfWeek, int minDaysInFirstWeek) {
        cal.setFirstDayOfWeek(firstDayOfWeek);
        Calendar.getInstance().setMinimalDaysInFirstWeek(minDaysInFirstWeek);
    }

    public static void resetConfigCalendarWeekDetails(Calendar cal) {
        cal.setFirstDayOfWeek(1);
        cal.setMinimalDaysInFirstWeek(1);
    }

    public static DateFormat getSQLDateFormat() {
        return SQL_DATE_FORMAT.getFormat();
    }

    public static DateFormat getSQLTimestampFormat() {
        return SQL_TIMESTAMP_FORMAT.getFormat();
    }

    public static DateFormat getSQLTimeFormat() {
        return SQL_TIME_FORMAT.getFormat();
    }

    public static Integer getDayOfWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int day = cal.get(7);
        if (day == 1) {
            return 7;
        }
        return day - 1;
    }

    public static Date addTime(Date date, int type, int amount) {
        if (date != null) {
            Calendar calendar = DateTimeUtils.getCalendar(date);
            calendar.add(type, amount);
            return calendar.getTime();
        }
        throw new IllegalArgumentException("Date input cannot be NULL!");
    }

    public static DateFormat getBasicDateFormat() {
        return BASIC_DATE_FORMAT.getFormat();
    }

    public static String getBasicDateString(Date date) {
        if (date != null) {
            return BASIC_DATE_FORMAT.getFormat().format(date);
        }
        throw new IllegalArgumentException("Date input cannot be NULL!");
    }

    public static String getDetailedDateString(Date date) {
        if (date != null) {
            return DETAILED_DATE_FORMAT.getFormat().format(date);
        }
        throw new IllegalArgumentException("Date input cannot be NULL!");
    }

    public static DateFormat getDateOfBirthFormat() {
        return DATE_OF_BIRTH_FORMAT.getFormat();
    }

    public static DateFormat getConsistentReportFormat() {
        return CONSISTENT_REPORT_FORMAT.getFormat();
    }

    public static DateFormat getConsistent24HourReportDateFormat() {
        return CONSISTENT_24_HOUR_REPORT_FORMAT.getFormat();
    }

    public static Date getNextSundayDay(Calendar date) {
        if (date.get(7) == 1) {
            date.add(5, 1);
        }
        while (date.get(7) != 1) {
            date.add(5, 1);
        }
        return date.getTime();
    }

    public static String getLongDateString(Date date) {
        if (date != null) {
            return LONG_DATE_FORMAT.getFormat().format(date);
        }
        throw new IllegalArgumentException("Date input cannot be NULL!");
    }

    public static Time roundToMinutes(Time time, int numMins) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        cal = DateTimeUtils.roundToMinutes(cal, numMins);
        Time retval = new Time(cal.getTimeInMillis());
        return retval;
    }

    public static Calendar roundToMinutes(Calendar cal, int numMins) {
        int currentMinutes = cal.get(12);
        int newMinutes = currentMinutes / numMins * numMins;
        if (currentMinutes % numMins > numMins / 2) {
            newMinutes += numMins;
        }
        cal.set(12, newMinutes);
        return cal;
    }

    public static Time addMinutesToTime(Time time, int amount) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        cal.add(12, amount);
        return new Time(cal.getTimeInMillis());
    }

    public static int compareDates(Date date, Date anotherDate, boolean includeTime) {
        if (date == null || anotherDate == null) {
            throw new IllegalArgumentException("The given date parameters cannot be null! Date: " + date + "Another Date: " + anotherDate);
        }
        if (!includeTime) {
            Date dateWithoutTime = DateTimeUtils.clearTimePart(date);
            Date anotherDateWithoutTime = DateTimeUtils.clearTimePart(anotherDate);
            return dateWithoutTime.compareTo(anotherDateWithoutTime);
        }
        return date.compareTo(anotherDate);
    }

    public static String computeElapsedTimeString(long millis, boolean elapsedTime) {
        long hours = millis / 3600000L;
        long minutes = (millis %= 3600000L) / 60000L;
        long seconds = (millis %= 60000L) / 1000L;
        StringBuilder sb = new StringBuilder();
        if (hours != 0L) {
            sb.append(hours).append("hr ");
        }
        if (minutes != 0L) {
            sb.append(minutes).append("min ");
        }
        if (elapsedTime) {
            if (seconds != 0L && minutes == 0L) {
                sb.append(seconds).append("sec");
            }
        } else if (seconds != 0L) {
            sb.append(seconds).append("sec");
        }
        return sb.toString().trim();
    }

    public static String convertToReadableTime(long millis) {
        return DateTimeUtils.computeElapsedTimeString(millis, false);
    }

    public static void rebuildDateFormatCache() {
        MEDIUM_CACHE.set(DateFormat.getDateInstance(2));
        SHORT_CACHE.set(DateFormat.getDateInstance(3));
    }

    public static String parseUTCText(Date value) {
        SimpleDateFormat sdf = new SimpleDateFormat(ISO8601_UTC_DateFormat);
        return sdf.format(value);
    }

    public static Date getDaysBefore(int daysBefore) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -daysBefore);
        return calendar.getTime();
    }

    public static String formatWithMilliseconds(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return sdf.format(date);
    }

    public static class ThreadLocalDateFormat
    extends ThreadLocal<DateFormat> {
        private final DateFormat dateFormat;

        public ThreadLocalDateFormat(DateFormat format) {
            this.dateFormat = format;
        }

        public DateFormat getFormat() {
            return (DateFormat)this.get();
        }

        @Override
        protected DateFormat initialValue() {
            return (DateFormat)this.dateFormat.clone();
        }
    }
}

