/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.MathsUtils;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.finance.tax.TaxMan;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import ordermate.database.finance.Denomination;
import ordermate.database.inventory.InventoryItemUnit;

public class FinanceUtils {
    private static final double ZERO_NO_ROUND = 0.0;
    private static final double TAX_RATE = 0.1;

    public static double calcGrossProfit(double salePriceIncTax, double taxAmount, double costPriceExTax) {
        double salesExTax = salePriceIncTax - taxAmount;
        return FinanceUtils.calcGrossProfit(salesExTax, costPriceExTax);
    }

    public static double calcGrossProfitMargin(double salePriceIncTax, double taxAmount, double costPriceExTax) {
        double salesExTax = salePriceIncTax - taxAmount;
        return FinanceUtils.calcGrossProfitMargin(salesExTax, costPriceExTax);
    }

    public static Price calcGrossProfit(Price salesPriceIncTax, Price taxAmount, Price costPriceExTax) {
        double gp = FinanceUtils.calcGrossProfit(salesPriceIncTax.doubleValue() - taxAmount.doubleValue(), costPriceExTax.doubleValue());
        return new Price(gp, 1.0E-6);
    }

    public static String formatAsPercentage(double value, DecimalFormat format) {
        return format.format(value) + "%";
    }

    public static String formatAsPercentage(double value) {
        Double rounded = new Double(MathsUtils.roundDoubleToDecPlaces(value, 2));
        String formattedString = rounded.toString() + "%";
        return formattedString;
    }

    public static double calcGrossProfitMargin(Price salesPriceIncTax, Price taxAmount, Price costPriceExTax) {
        return FinanceUtils.calcGrossProfitMargin(salesPriceIncTax.doubleValue() - taxAmount.doubleValue(), costPriceExTax.doubleValue());
    }

    public static double calcGrossProfit(double salePriceExTax, double costPriceExTax) {
        return salePriceExTax - costPriceExTax;
    }

    public static double calcGrossProfitMargin(double salePriceExTax, double costPriceExTax) {
        if (MathsUtils.approxEquals(0.0, salePriceExTax)) {
            return 0.0;
        }
        return FinanceUtils.calcGrossProfit(salePriceExTax, costPriceExTax) / salePriceExTax * 100.0;
    }

    public static double getTaxValue(double taxInclusiveAmount, double rate) {
        return FinanceUtils.getTaxMultiplier(rate) * taxInclusiveAmount;
    }

    public static Price getTaxValue(Price taxInclusivePrice, double rate) {
        return new Price(FinanceUtils.getTaxValue(taxInclusivePrice.doubleValue(), rate), taxInclusivePrice.getRoundAmount());
    }

    public static double removeTax(double taxInclusiveAmount, double rate) {
        return taxInclusiveAmount / (1.0 + rate);
    }

    public static Price removeTax(Price taxInclusivePrice, double rate) {
        return new Price(FinanceUtils.removeTax(taxInclusivePrice.doubleValue(), rate), taxInclusivePrice.getRoundAmount());
    }

    public static double addTax(double taxExclusiveAmount, double rate) {
        return taxExclusiveAmount + taxExclusiveAmount * rate;
    }

    public static Price addTax(Price TaxExclusivePrice, double rate) {
        return new Price(FinanceUtils.addTax(TaxExclusivePrice.doubleValue(), rate), TaxExclusivePrice.getRoundAmount());
    }

    public static double getTaxMultiplier(double rate) {
        return rate / (1.0 + rate);
    }

    public static double getRemoveTaxMultiplier(double rate) {
        return 1.0 / (1.0 + rate);
    }

    public static Double percDifference(Price now, Price then) {
        Price theNow = now;
        Price theThen = then;
        if (theNow == null) {
            theNow = Price.ZERO_DOLLAR;
        }
        if (theThen == null) {
            theThen = Price.ZERO_DOLLAR;
        }
        if (theThen == Price.ZERO_DOLLAR) {
            return null;
        }
        double difference = theNow.doubleValue() - theThen.doubleValue();
        return difference / theThen.doubleValue();
    }

    public static Double calcGrossProfitPercent(long itemUnitID, double unitSales, double unitCostExcl) {
        Price grossProfit = new Price(FinanceUtils.getGrossProfit(itemUnitID, unitSales, unitCostExcl), 0.0);
        Price totalSales = new Price(unitSales, 0.0);
        if (!grossProfit.isZero() && !totalSales.isZero()) {
            double gPPercent = grossProfit.doubleValue() / (totalSales.doubleValue() - FinanceUtils.getUnitSalesTax(itemUnitID, unitSales).doubleValue()) * 100.0;
            return new Double(MathsUtils.roundDoubleToDecPlaces(gPPercent, 1));
        }
        return 0.0;
    }

    public static Price getGrossProfit(long itemUnitID, double unitSales, double unitCostExcl) {
        Price totalSales = new Price(unitSales, 0.0);
        return totalSales.subtract(FinanceUtils.getUnitSalesTax(itemUnitID, unitSales)).subtract(new Price(unitCostExcl, 0.0));
    }

    public static Price getUnitSalesTax(long itemUnitID, double unitSales) {
        InventoryItemUnit itemUnit = PersistenceManager.getByID(itemUnitID, InventoryItemUnit.class);
        Price totalSales = new Price(unitSales, 0.0);
        return TaxMan.getInstance().getTotalTax(totalSales, itemUnit.getTaxCodes());
    }

    public static String denominationToString(Denomination nom) {
        if (nom.getValue() >= 1.0) {
            return "$" + (int)nom.getValue();
        }
        return (int)(nom.getValue() * 100.0) + "c";
    }

    public static BigDecimal centsToDollarCents(int cents) {
        int dollarPart = cents / 100;
        int centsPart = cents % 100;
        return new BigDecimal(String.format("%d.%02d", dollarPart, centsPart));
    }
}

