/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.util.StringUtils;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Arrays;
import java.util.List;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import ordermate.OrderMate;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.OrderMateFont;

public class FontManagerUtil {
    private static final String BASE_FONT_DIR = "/utils/fonts/";
    private static final String SYSTEM_FONT = "/utils/fonts/" + OrderMateFont.NOTO_SANS_REGULAR.toString();
    private static final float DEFAULT_FONT_SIZE = 12.0f;
    private static final float DEFAULT_FONT_SCALING_DIVISOR = 10.0f;
    private static Font currentFont;

    public static Font loadAndRegisterFont(String filePath, float fontSize) {
        if (filePath == null || filePath.equals("")) {
            return null;
        }
        Font fontToReturn = null;
        try {
            Font actualFont = Font.createFont(0, FontManagerUtil.class.getResourceAsStream(filePath));
            actualFont = actualFont.deriveFont(fontSize);
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            boolean fontExists = false;
            List<Font> allFonts = Arrays.asList(ge.getAllFonts());
            for (Font aFont : allFonts) {
                if (!aFont.getFontName().equals(actualFont.getFontName())) continue;
                actualFont = aFont;
                fontExists = true;
                break;
            }
            if (!fontExists) {
                ge.registerFont(actualFont);
            }
            fontToReturn = actualFont.deriveFont(0, fontSize);
        }
        catch (Exception e) {
            OrderMate.LOG.warn("Could not register special font from: " + filePath, (Throwable)e);
        }
        return fontToReturn;
    }

    public static String setupFonts() {
        return FontManagerUtil.setupFonts(12);
    }

    public static String setupFonts(int fontSize) {
        float fontScale = (float)fontSize / 10.0f;
        float scaledFontSize = 12.0f * fontScale;
        Font actualFont = FontManagerUtil.getFont(Config.getStringValue("font"), (int)scaledFontSize);
        FontManagerUtil.updateUIFont(actualFont);
        currentFont = actualFont;
        return actualFont.getFontName();
    }

    protected static Font getFont(String customFontName, int size) {
        Font actualFont;
        if (!StringUtils.isEmpty(customFontName) && FontManagerUtil.fontExistsInGraphicsEnvironment(customFontName)) {
            actualFont = new Font(customFontName, 0, size);
        } else {
            String ourFontInCorrectLanguage = FontManagerUtil.getFontFromLanguageSettings();
            actualFont = FontManagerUtil.loadAndRegisterFont(ourFontInCorrectLanguage, size);
            if (actualFont == null) {
                OrderMate.LOG.error("Couldn't get our special font from " + ourFontInCorrectLanguage);
                String fontName = "SansSerif";
                actualFont = new Font(fontName, 0, size);
            }
        }
        return actualFont;
    }

    private static String getFontFromLanguageSettings() {
        try {
            return BASE_FONT_DIR + SystemProperty.getInstance().getLanguageSupport().getFontName();
        }
        catch (Exception e) {
            return SYSTEM_FONT;
        }
    }

    public static Font getCurrentFont() {
        if (currentFont == null) {
            FontManagerUtil.setupFonts(12);
        }
        return currentFont;
    }

    private static void updateUIFont(Font fontToUse) {
        Font actualFont;
        currentFont = actualFont = fontToUse;
        actualFont = new FontUIResource(actualFont);
        UIManager.put("Label.font", actualFont);
        UIManager.put("Button.font", actualFont);
        UIManager.put("ToggleButton.font", actualFont);
        UIManager.put("ComboBox.font", actualFont);
        UIManager.put("CheckBox.font", actualFont);
        UIManager.put("TabbedPane.font", actualFont);
        UIManager.put("Spinner.font", actualFont);
        UIManager.put("TextArea.font", actualFont);
        UIManager.put("TextField.font", actualFont);
        UIManager.put("FormattedTextField.font", actualFont);
        UIManager.put("MenuItem.font", actualFont);
        UIManager.put("Menu.font", actualFont);
        UIManager.put("MenuBar.font", actualFont);
        UIManager.put("List.font", actualFont);
        UIManager.put("Table.font", actualFont);
        UIManager.put("TableHeader.font", actualFont);
        UIManager.put("ProgressBar.font", actualFont);
        UIManager.put("Tree.font", actualFont);
    }

    private static boolean fontExistsInGraphicsEnvironment(String fontName) {
        String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        return Arrays.asList(fonts).contains(fontName);
    }
}

