/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util;

import au.com.ordermate.OrderMateLog;
import java.awt.Color;
import java.awt.Point;
import java.util.StringTokenizer;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import ordermate.jaxb.exporter.handlers.posdatabase.converters.Converters;

public final class GuiUtils {
    public static final int HEX_CODE_WHITE = 0xFFFFFF;
    public static final String HEX_STRING_PREFIX = "#";
    public static final String ZEROES_FOR_HEX_CONVERSION = "000000";
    public static final String HEX_STRING_WHITE = "#ffffff";

    public static void scrollToTableRow(JScrollPane scroller, JTable table, int row) {
        int rowHeight = table.getRowHeight();
        int panelHeight = scroller.getHeight() - table.getTableHeader().getHeight();
        int maxHeight = table.getRowCount() * rowHeight;
        if (maxHeight > panelHeight) {
            int yPos = row * rowHeight;
            int maxScrollableHeight = maxHeight - panelHeight;
            if (yPos > maxScrollableHeight) {
                yPos = maxScrollableHeight;
            }
            scroller.getViewport().setViewPosition(new Point(0, yPos));
        }
    }

    public static Color makeColor(String rawString) {
        if (rawString != null) {
            StringTokenizer st = new StringTokenizer(rawString.trim(), ",");
            if (st.countTokens() == 3) {
                try {
                    int r = Integer.parseInt(st.nextToken().trim());
                    r = Math.min(r, 255);
                    r = Math.max(r, 0);
                    int g = Integer.parseInt(st.nextToken().trim());
                    g = Math.min(g, 255);
                    g = Math.max(g, 0);
                    int b = Integer.parseInt(st.nextToken().trim());
                    b = Math.min(b, 255);
                    b = Math.max(b, 0);
                    return new Color(r, g, b);
                }
                catch (NumberFormatException e) {
                    OrderMateLog.LOG.error(e.toString(), (Throwable)e);
                    return null;
                }
            }
            if (st.countTokens() == 4) {
                try {
                    int r = Integer.parseInt(st.nextToken());
                    r = Math.min(r, 255);
                    r = Math.max(r, 0);
                    int g = Integer.parseInt(st.nextToken());
                    g = Math.min(g, 255);
                    g = Math.max(g, 0);
                    int b = Integer.parseInt(st.nextToken());
                    b = Math.min(b, 255);
                    b = Math.max(b, 0);
                    int alpha = Integer.parseInt(st.nextToken());
                    alpha = Math.min(alpha, 255);
                    alpha = Math.max(alpha, 0);
                    return new Color(r, g, b, alpha);
                }
                catch (NumberFormatException e) {
                    OrderMateLog.LOG.error(e.toString(), (Throwable)e);
                    return null;
                }
            }
            return null;
        }
        return null;
    }

    public static String colorAsString(Color color) {
        String stringVal = color.getRed() + "," + color.getGreen() + "," + color.getBlue();
        if (color.getAlpha() != 255) {
            stringVal = stringVal + "," + color.getAlpha();
        }
        return stringVal;
    }

    public static String colorAsHex(Color color) {
        return Converters.getConverterFor(Color.class).convertToString(color);
    }

    public static String toHexString(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("The color CANNOT be NULL to convert into hexadecimal string!");
        }
        String hexColour = Integer.toHexString(color.getRGB() & 0xFFFFFF);
        if (hexColour.length() < 6) {
            hexColour = ZEROES_FOR_HEX_CONVERSION.substring(0, 6 - hexColour.length()) + hexColour;
        }
        return HEX_STRING_PREFIX + hexColour;
    }

    public static String getRandomColorHex() {
        int rgb = (int)(Math.random() * 1.6777216E7);
        return HEX_STRING_PREFIX + Integer.toHexString(rgb);
    }

    private GuiUtils() {
    }
}

