/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util;

import au.com.ordermate.util.HtmlUtils;
import ordermate.OrderMate;

public class HtmlBuilder {
    private StringBuilder builder = new StringBuilder();

    public HtmlBuilder appendRaw(String text) {
        this.builder.append(text);
        return this;
    }

    public HtmlBuilder append(String text) {
        this.builder.append(text.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;"));
        return this;
    }

    public HtmlBuilder appendLineBreak() {
        this.builder.append(HtmlUtils.newline(1));
        return this;
    }

    public HtmlBuilder appendLineBreak(int total) {
        this.builder.append(HtmlUtils.newline(total));
        return this;
    }

    public HtmlBuilder appendColor(String text, String color) {
        this.builder.append(HtmlUtils.highlight(text, color, false, false));
        return this;
    }

    public HtmlBuilder appendBold(String text) {
        this.builder.append(HtmlUtils.highlight(text, null, true, false, 0));
        return this;
    }

    public HtmlBuilder appendItalic(String text) {
        this.builder.append(HtmlUtils.highlight(text, null, false, true, 0));
        return this;
    }

    public HtmlBuilder appendBoldColor(String text, String color) {
        this.builder.append(HtmlUtils.highlight(text, color, true, false, 0));
        return this;
    }

    public HtmlBuilder appendFont(String text, String color, boolean bold, boolean italic, int fontSize) {
        this.builder.append(HtmlUtils.highlight(text, color, bold, italic, fontSize));
        return this;
    }

    public HtmlBuilder appendTextWithHeading(String text, int headingSize) {
        this.builder.append(HtmlUtils.heading(text, headingSize));
        return this;
    }

    public HtmlBuilder appendCenter(String text) {
        this.builder.append(HtmlUtils.center(text));
        return this;
    }

    public HtmlBuilder center() {
        String text = HtmlUtils.center(this.builder.toString());
        this.builder = new StringBuilder().append(text);
        return this;
    }

    public HtmlBuilder italic() {
        String text = HtmlUtils.highlight(this.builder.toString(), null, false, true);
        this.builder = new StringBuilder().append(text);
        return this;
    }

    public HtmlBuilder heading(int size) {
        if (size > 0 && size < 7) {
            String text = HtmlUtils.heading(this.builder.toString(), size);
            this.builder = new StringBuilder().append(text);
        } else {
            OrderMate.LOG.warn("Warning: HtmlBuilder - Incorrect size given to heading");
        }
        return this;
    }

    public String toString() {
        return HtmlUtils.html(this.builder.toString());
    }
}

