/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util;

import ordermate.OrderMate;

public class HtmlUtils {
    public static final String GREEN = "green";
    public static final String BLACK = "black";
    public static final String GREY = "gray";
    public static final String BLUE = "blue";
    public static final String LIGHT_GREY = "#B3B3B3";
    @Deprecated
    public static final String RED = "red";
    @Deprecated
    public static final String ORANGE = "orange";
    public static final String CRIMSON = "#DC143C";
    public static final String GOLDEN_ROD = "#DAA520";
    public static final String GUNMETAL = "#2C3539";
    public static final String NEW_LINE = "<br>";
    public static final int FONT_SMALL = 2;
    public static final int FONT_NORMAL = 3;

    public static String html(String text) {
        return "<html>" + text + "</html>";
    }

    public static String htmlHeader(String text, int size) {
        if (size < 1 || size > 6) {
            throw new IllegalArgumentException("Html header size must be between 1(inclusive) and 6(inclusive), size: " + size);
        }
        return "<html><h" + size + ">" + text + "</h" + size + "></html>";
    }

    public static String htmlCenter(String text) {
        return "<html><div style=\"text-align: center;\">" + text + "</div></html>";
    }

    public static String center(String text) {
        return "<div style=\"text-align: center;\">" + text + "</div>";
    }

    public static String heading(String text, int size) {
        if (size > 0 && size < 7) {
            StringBuilder builder = new StringBuilder("<h");
            builder.append(size).append(">").append(text).append("</h").append(size).append(">");
            return builder.toString();
        }
        OrderMate.LOG.warn("Warning: HtmlUtils - Incorrect size given to heading");
        return text;
    }

    public static String addSpaces(int number) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < number; ++i) {
            sb.append("&nbsp;");
        }
        return sb.toString();
    }

    public static String newline(int number) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < number; ++i) {
            sb.append("<br />");
        }
        return sb.toString();
    }

    public static String table(String[][] tableContents, boolean hasHeaders, boolean hasBorder) {
        StringBuilder sb = new StringBuilder();
        int rowStart = 0;
        sb.append("<table");
        if (hasBorder) {
            sb.append(" border=\"1\"");
        }
        sb.append(">");
        if (hasHeaders) {
            rowStart = 1;
            sb.append("<tr>");
            for (int i = 0; i < tableContents[0].length; ++i) {
                sb.append("<th>");
                sb.append(tableContents[0][i]);
                sb.append("</th>");
            }
            sb.append("</tr>");
        }
        while (rowStart < tableContents.length) {
            sb.append("<tr>");
            for (int column = 0; column < tableContents[rowStart].length; ++column) {
                sb.append("<td>");
                sb.append(tableContents[rowStart][column]);
                sb.append("</td>");
            }
            sb.append("</tr>");
            ++rowStart;
        }
        sb.append("</table>");
        return sb.toString();
    }

    public static String highlight(String text, String color, boolean bold, boolean italic) {
        return HtmlUtils.highlight(text, color, bold, italic, 0);
    }

    public static String highlight(String text, String color, boolean bold, boolean italic, int fontSize) {
        HtmlUtils.validateText(text);
        StringBuilder sb = new StringBuilder();
        HtmlUtils.startBoldTag(bold, sb);
        HtmlUtils.startItalicTag(italic, sb);
        HtmlUtils.startFontTag(color, fontSize, sb);
        HtmlUtils.appendText(text, sb);
        if (color != null || fontSize > 0) {
            HtmlUtils.endFontTag(sb);
        }
        HtmlUtils.endItalicTag(italic, sb);
        HtmlUtils.endBoldTag(bold, sb);
        return sb.toString();
    }

    public static String fontSize(String text, int fontSize) {
        HtmlUtils.validateText(text);
        StringBuilder sb = new StringBuilder();
        HtmlUtils.startFontSize(fontSize, sb);
        HtmlUtils.appendText(text, sb);
        HtmlUtils.endFontTag(sb);
        return sb.toString();
    }

    public static void startFontTag(String color, int fontSize, StringBuilder sb) {
        if (color != null || fontSize > 0) {
            sb.append("<font ");
            if (color != null) {
                sb.append("color=\"").append(color).append("\"");
            }
            if (fontSize > 0) {
                sb.append(" size=\"").append(fontSize).append("\"");
            }
            sb.append(">");
        }
    }

    public static void startFontSize(int fontSize, StringBuilder sb) {
        sb.append("<font ");
        if (fontSize > 0) {
            sb.append(" size=\"").append(fontSize).append("\">");
        } else {
            sb.append(">");
        }
    }

    public static void endFontTag(StringBuilder sb) {
        sb.append("</font>");
    }

    private static void validateText(String text) {
        if (text == null) {
            throw new IllegalArgumentException("Hightlight text cannot be null");
        }
    }

    public static void appendText(String text, StringBuilder sb) {
        sb.append(text.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;"));
    }

    public static void endBoldTag(boolean bold, StringBuilder sb) {
        if (bold) {
            sb.append("</b>");
        }
    }

    public static void endItalicTag(boolean italic, StringBuilder sb) {
        if (italic) {
            sb.append("</i>");
        }
    }

    public static void startItalicTag(boolean italic, StringBuilder sb) {
        if (italic) {
            sb.append("<i>");
        }
    }

    public static void startBoldTag(boolean bold, StringBuilder sb) {
        if (bold) {
            sb.append("<b>");
        }
    }

    public static String colour(String text, String colour) {
        StringBuilder sb = new StringBuilder();
        HtmlUtils.startFontTag(colour, 0, sb);
        HtmlUtils.appendText(text, sb);
        HtmlUtils.endFontTag(sb);
        return sb.toString();
    }

    public static String boldColor(String text, String color) {
        return HtmlUtils.highlight(text, color, true, false);
    }

    public static String orderedList(boolean ordered, String ... listItems) {
        StringBuilder SB = new StringBuilder(ordered ? "<ol>" : "<ul>");
        for (String nextItem : listItems) {
            SB.append("<li>").append(nextItem).append("</li>\r\n");
        }
        SB.append(ordered ? "</ol>" : "</ul>");
        return SB.toString();
    }
}

