/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.util.ListUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ordermate.OrderMate;

public class IPAddressUtils {
    private static final String CHECKIP_MESSAGE = "Current IP Address: ";
    private static final String CHECKIP_URL = "http://checkip.dyndns.org/";
    private static final Pattern IP_PATTERN = Pattern.compile("\\d\\d?\\d?\\.\\d\\d?\\d?\\.\\d\\d?\\d?\\.\\d\\d?\\d?");

    @Deprecated
    public static final String getIPAddress() {
        String ipAddress = "";
        ipAddress = IPAddressUtils.readCheckIpAddress();
        return ipAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private static String readCheckIpAddress() {
        String ipAddress = null;
        URL theUrl = null;
        try {
            theUrl = new URL(CHECKIP_URL);
        }
        catch (MalformedURLException ex) {
            OrderMate.LOG.error("URL is malformed : http://checkip.dyndns.org/");
            if (Config.isDebuging()) {
                throw new RuntimeException();
            }
            return "";
        }
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(theUrl.openStream()));
            ipAddress = in.readLine();
        }
        catch (IOException ex) {
            OrderMate.LOG.error("Unable to get IP Address " + ex.getMessage());
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException oops) {
                OrderMate.LOG.warn("Exception caught closing connection : ", (Throwable)oops);
            }
        }
        if (ipAddress != null && ipAddress.length() > CHECKIP_MESSAGE.length()) {
            return IPAddressUtils.findIpText(ipAddress);
        }
        ipAddress = "";
        return ipAddress;
    }

    private IPAddressUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static String findIpText(String ip) {
        Matcher matcher = IP_PATTERN.matcher(ip);
        if (matcher.find()) {
            return matcher.group();
        }
        return "";
    }

    public static List<InetAddress> getLocalAddresses() {
        ArrayList<InetAddress> locals = new ArrayList<InetAddress>();
        try {
            boolean isDebian = false;
            for (InetAddress address : InetAddress.getAllByName(InetAddress.getLocalHost().getHostName())) {
                if (address.getHostAddress().contains(":")) continue;
                locals.add(address);
                isDebian |= "127.0.1.1".equals(address.getHostAddress());
            }
            if (isDebian) {
                locals.clear();
                Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
                while (en.hasMoreElements()) {
                    NetworkInterface ni = en.nextElement();
                    if (ni.isVirtual() || ni.isLoopback() || !ni.isUp()) continue;
                    Enumeration<InetAddress> ee = ni.getInetAddresses();
                    while (ee.hasMoreElements()) {
                        InetAddress ia = ee.nextElement();
                        if (ia.getHostAddress().contains(":")) continue;
                        locals.add(ia);
                    }
                }
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot obtain local IP addresses:" + ex);
        }
        return locals;
    }

    public static boolean hasInvalidHostNameChars(String str) {
        String INVALID_CHARS = "!\"#$%&'()*+,/:;<=>?@[\\]^`{|}~";
        for (int i = 0; i < "!\"#$%&'()*+,/:;<=>?@[\\]^`{|}~".length(); ++i) {
            if (str.indexOf("!\"#$%&'()*+,/:;<=>?@[\\]^`{|}~".charAt(i)) == -1) continue;
            return true;
        }
        return false;
    }

    public static List<InetAddress> getAllAddressesForHost(String hostname) {
        List<Object> addresses = new ArrayList();
        try {
            addresses = Arrays.asList(InetAddress.getAllByName(hostname));
            OrderMate.LOG.info("Found " + addresses.size() + " IP addresses for host \"" + hostname + "\"\r\n" + ListUtils.listToString(addresses, ", "));
        }
        catch (Exception e) {
            OrderMate.LOG.warn("Failed to find IP addresses for host: " + hostname, (Throwable)e);
        }
        return addresses;
    }
}

