/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import ordermate.OrderMate;

public class JSONUtil {
    public static String toJson(Object toConvert) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
            mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
            mapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX"));
            mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
            JacksonAnnotationIntrospector introspector = new JacksonAnnotationIntrospector();
            mapper.setAnnotationIntrospector((AnnotationIntrospector)introspector);
            String result = mapper.writeValueAsString(toConvert);
            return result;
        }
        catch (JsonProcessingException ex) {
            OrderMate.LOG.error("Failed to convert object to Json", (Throwable)ex);
            return null;
        }
    }

    public static <T> T fromJson(Class<T> clazz, String json) throws JsonParseException, IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        Object object = objectMapper.readValue(json, clazz);
        return (T)object;
    }

    public static <T> List<T> fromJsonToList(Class<T> clazz, String json) throws JsonParseException, IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        List list = (List)objectMapper.readValue(json, (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, clazz));
        return list;
    }
}

