/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util;

import au.com.ordermate.OrderMateLog;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;

public class LangUtils {
    public static int getObjectSize(Object toSerialize) {
        int size = 0;
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            ObjectOutputStream objectOut = new ObjectOutputStream(byteOut);
            objectOut.writeObject(toSerialize);
            size = byteOut.toByteArray().length;
        }
        catch (Exception e) {
            OrderMateLog.LOG.error("Error calculating object tree size", (Throwable)e);
        }
        return size;
    }

    public static <T> T[] joinArrays(T[] array1, T[] array2, Class<T> arrayClass) {
        int newLength = array1.length + array2.length;
        Object[] combinedArrays = (Object[])Array.newInstance(arrayClass, newLength);
        System.arraycopy(array1, 0, combinedArrays, 0, array1.length);
        System.arraycopy(array2, 0, combinedArrays, array1.length, array2.length);
        return combinedArrays;
    }

    public static Class getDeclaringClass(Class toFind) {
        String className = toFind.getName();
        if (className.indexOf("$") == -1) {
            return null;
        }
        String declaringClassName = className.substring(0, className.indexOf("$"));
        try {
            Class<?> declaringClass = Class.forName(declaringClassName);
            return declaringClass;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot load class " + declaringClassName);
        }
    }
}

