/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util;

import au.com.ordermate.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ListUtils {
    private ListUtils() {
    }

    public static final <T> String listToString(List<T> list, String separator) {
        ArrayList<String> toStringList = new ArrayList<String>();
        for (T obj : list) {
            if (obj == null) continue;
            toStringList.add(obj.toString());
        }
        return StringUtils.mergeWithSeparator(toStringList, separator);
    }

    public static final <T> void safelyAddToList(T item, List<T> list, int index) {
        if (index >= 0 && index < list.size()) {
            list.add(index, item);
        } else {
            list.add(item);
        }
    }

    public static final <T> void safelyAddBefore(T item, List<T> list, T before) {
        ListUtils.safelyAddToList(item, list, list.indexOf(before));
    }

    public static <T> List<T> listOf(T ... toAdd) {
        ArrayList localArray = new ArrayList();
        Collections.addAll(localArray, toAdd);
        return localArray;
    }
}

