/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util;

import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.macaddr.MacAddressFromSystem;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import ordermate.OrderMate;

public final class MACAddress {
    public static List<String> getMacAddress() {
        ArrayList<String> macAddressList = new ArrayList<String>();
        try {
            for (NetworkInterface eth0 : MACAddress.getNetworkInterfaces()) {
                byte[] mac = MACAddress.getHardwareAddress(eth0);
                if (mac == null || mac.length <= 0) continue;
                String macTemp = MACAddress.getMacString(mac);
                OrderMate.LOG.info("Network Interface: " + eth0 + ", MAC:" + macTemp + ", Up? " + MACAddress.isNetworkInterfaceUp(eth0) + ", Virtual? " + eth0.isVirtual());
                macAddressList.add(macTemp);
                MACAddress.addMacAddressesOfSubInterfaces(macAddressList, eth0);
            }
            return macAddressList;
        }
        catch (Exception e) {
            OrderMate.LOG.error("Exception caught attempting to obtain MAC address: " + e, (Throwable)e);
            return null;
        }
    }

    private static List<NetworkInterface> getNetworkInterfaces() throws SocketException {
        return Collections.list(NetworkInterface.getNetworkInterfaces());
    }

    private static void addMacAddressesOfSubInterfaces(List<String> macAddressList, NetworkInterface networkInterface) {
        Enumeration<NetworkInterface> subInterfaces = networkInterface.getSubInterfaces();
        for (NetworkInterface subInterface : Collections.list(subInterfaces)) {
            byte[] subMac = MACAddress.getHardwareAddress(subInterface);
            if (subMac == null) continue;
            String sucMacTemp = MACAddress.getMacString(subMac);
            OrderMate.LOG.info("Sub Network Interface: " + subInterface + ", MAC:" + sucMacTemp + ", Up? " + MACAddress.isNetworkInterfaceUp(subInterface) + ", Virtual? " + subInterface.isVirtual());
            macAddressList.add(sucMacTemp);
        }
    }

    private static String getMacString(byte[] mac) {
        StringBuilder macStringBuilder = new StringBuilder();
        for (int i = 0; i < mac.length; ++i) {
            macStringBuilder.append(String.format("%02X", mac[i]));
        }
        return macStringBuilder.toString();
    }

    private static byte[] getHardwareAddress(NetworkInterface networkInterface) {
        byte[] mac = null;
        try {
            mac = networkInterface.getHardwareAddress();
        }
        catch (SocketException e) {
            OrderMate.LOG.error("Exception caught attempting to obtain MAC address of network interface " + networkInterface + ",exception:" + e, (Throwable)e);
        }
        return mac;
    }

    private static boolean isNetworkInterfaceUp(NetworkInterface networkInterface) {
        boolean interfaceUp = false;
        try {
            interfaceUp = networkInterface.isUp();
        }
        catch (SocketException e) {
            OrderMate.LOG.error("Exception caught attempting to check interface is up!" + e, (Throwable)e);
        }
        return interfaceUp;
    }

    public static String getFirstNonEmptyMac() {
        List<String> addresses = MACAddress.getMacAddress();
        if (addresses != null) {
            for (String nextAddress : addresses) {
                if (StringUtils.isEmpty(nextAddress) || nextAddress.contains("000000")) continue;
                return nextAddress;
            }
        }
        return null;
    }

    public static List<String> getMacAddressFromScript() {
        return new MacAddressFromSystem().getMacAddressFromSystem();
    }
}

