/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util;

import java.math.BigDecimal;
import java.math.RoundingMode;

public final class MathsUtils {
    private static final double APPROX_ZERO = 1.0E-9;

    public static boolean approxEquals(double a, double b) {
        return Math.abs(a - b) <= 1.0E-9;
    }

    public static boolean approxGreaterThan(double a, double b) {
        return a - b > 1.0E-9;
    }

    public static double roundDownAsCents(double a) {
        return Math.floor(a * 100.0) / 100.0;
    }

    public static boolean approxLessThan(double a, double b) {
        return a - b <= -1.0E-9;
    }

    public static boolean approxGreaterThanEquals(double a, double b) {
        return a - b >= -1.0E-9;
    }

    public static boolean approxLessThanEquals(double a, double b) {
        return a - b <= 1.0E-9;
    }

    public static double roundDouble(double toRound, double roundAmt) {
        if (Double.isNaN(toRound) || Double.isInfinite(toRound) || 0.0 == toRound || roundAmt == 0.0) {
            return toRound;
        }
        BigDecimal sign = BigDecimal.valueOf(Math.signum(toRound));
        int roundScale = BigDecimal.valueOf(Math.log10(roundAmt)).abs().setScale(0, RoundingMode.CEILING).intValue();
        BigDecimal roundMultiplier = BigDecimal.ONE.divide(BigDecimal.valueOf(roundAmt), 10, RoundingMode.HALF_EVEN);
        BigDecimal roundedNumber = BigDecimal.valueOf(toRound).multiply(roundMultiplier).setScale(0, RoundingMode.HALF_EVEN).abs().divide(roundMultiplier, roundScale, RoundingMode.HALF_EVEN);
        return sign.multiply(roundedNumber).doubleValue();
    }

    public static double roundDoubleToDecPlaces(double toRound, int decPlaces) {
        return MathsUtils.roundDouble(toRound, new BigDecimal("0.1").pow(decPlaces).doubleValue());
    }

    public static String toStringWithLeadingZeroes(int number, int numDigits) {
        String numberStr = Integer.toString(number);
        if (numberStr.length() < numDigits) {
            char[] leadingChars = new char[numDigits - numberStr.length()];
            for (int i = 0; i < leadingChars.length; ++i) {
                leadingChars[i] = 48;
            }
            numberStr = new String(leadingChars) + numberStr;
        }
        return numberStr;
    }

    public static int shortenID(long value, int numPlaces) {
        int newValue = (int)((double)value % Math.pow(10.0, numPlaces));
        return Math.abs(newValue);
    }

    public static long cantorPair(int first, int second) {
        long value = (long)(0.5 * (double)(first + second) * (double)(first + second + 1) + (double)second);
        return value;
    }

    public static String neatenDouble(double value, int maxDecimalPlaces) {
        if (Math.floor(value) == value) {
            return Integer.toString((int)value);
        }
        return String.valueOf(MathsUtils.roundDoubleToDecPlaces(value, maxDecimalPlaces));
    }

    public static boolean checkIsInteger(double toCheck) {
        return toCheck == Math.floor(toCheck);
    }

    public static int clamp(int value, int max, int min) {
        if (min > max) {
            int tempMin = min;
            min = max;
            max = tempMin;
        }
        return Math.max(Math.min(value, max), min);
    }

    public static float clamp(float value, float max, float min) {
        if (min > max) {
            float tempMin = min;
            min = max;
            max = tempMin;
        }
        return Math.max(Math.min(value, max), min);
    }

    public static long clamp(long value, long max, long min) {
        if (min > max) {
            long tempMin = min;
            min = max;
            max = tempMin;
        }
        return Math.max(Math.min(value, max), min);
    }

    private MathsUtils() {
    }

    public static int getPercentageOf(int length, int percentage) {
        return length * percentage / 100;
    }
}

