/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util;

public interface NumberFunction<T extends Number> {
    public double doFunction(T var1, T var2);

    public static class DivideFunction<T extends Number>
    implements NumberFunction<T> {
        @Override
        public double doFunction(Number arg1, Number arg2) {
            if (arg2.doubleValue() == 0.0) {
                return arg1.doubleValue();
            }
            return arg1.doubleValue() / arg2.doubleValue();
        }

        public String toString() {
            return "Divide";
        }
    }

    public static class MultiplyFunction<T extends Number>
    implements NumberFunction<T> {
        @Override
        public double doFunction(Number arg1, Number arg2) {
            return arg1.doubleValue() * arg2.doubleValue();
        }

        public String toString() {
            return "Multiply";
        }
    }

    public static class SetFunction<T extends Number>
    implements NumberFunction<T> {
        @Override
        public double doFunction(Number arg1, Number arg2) {
            return arg2.doubleValue();
        }

        public String toString() {
            return "Set";
        }
    }

    public static class SubtractFunction<T extends Number>
    implements NumberFunction<T> {
        @Override
        public double doFunction(Number arg1, Number arg2) {
            return arg1.doubleValue() - arg2.doubleValue();
        }

        public String toString() {
            return "Subtract";
        }
    }

    public static class AddFunction<T extends Number>
    implements NumberFunction<T> {
        @Override
        public double doFunction(T arg1, T arg2) {
            return ((Number)arg1).doubleValue() + ((Number)arg2).doubleValue();
        }

        public String toString() {
            return "Add";
        }
    }
}

