/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util;

import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.MathsUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import ordermate.OrderMate;

public class Price
extends Number
implements Comparable<Price>,
Serializable,
Cloneable {
    private static ThreadLocal<NumberFormat> format = new ThreadLocal();
    private static String DOLLAR_SIGN = "$";
    public static final Price ZERO = new Price(0.0, 1.0E-6);
    public static final Price ZERO_NO_ROUND = new Price(0.0, 0.0);
    public static final Price ZERO_DOLLAR = new Price(0.0, 0.01);
    public static double DEFAULT_ROUND_AMOUNT = 0.05;
    public static final double ONE_CENT_ROUND_AMOUNT = 0.01;
    public static final double FOUR_CENT_ROUND_AMOUNT = 1.0E-4;
    public static final double FIVE_DECIMAL_ROUND_AMOUNT = 1.0E-5;
    public static final double EQUIVALENT_THRESHOLD = DEFAULT_ROUND_AMOUNT / 2.0;
    private final double value;
    private final double roundAmount;
    private final double origRawValue;
    private transient String toStringValue;

    public Price(double newValue) {
        this(newValue, DEFAULT_ROUND_AMOUNT);
    }

    public Price(Number number) {
        this(number.doubleValue());
    }

    public Price(Number number, double roundAmt) {
        this(number.doubleValue(), roundAmt);
    }

    public Price(double newValue, double roundAmt) {
        if (Double.isNaN(newValue)) {
            throw new IllegalArgumentException("Cannot create price from NaN");
        }
        this.origRawValue = newValue;
        this.roundAmount = roundAmt;
        this.value = MathsUtils.roundDouble(newValue, this.roundAmount);
    }

    public Price(String money) {
        this(money, 0.01);
    }

    public Price(String money, double roundAmt) {
        if (money == null) {
            throw new NumberFormatException("null");
        }
        String stringToParse = money.trim();
        if (stringToParse.length() == 0) {
            throw new NumberFormatException(money);
        }
        if (stringToParse.charAt(0) == '$') {
            stringToParse = stringToParse.substring(1);
        } else if (stringToParse.startsWith("-$")) {
            stringToParse = "-" + stringToParse.substring(2);
        } else if (stringToParse.startsWith(DOLLAR_SIGN)) {
            stringToParse = stringToParse.substring(DOLLAR_SIGN.length());
        } else if (stringToParse.startsWith("-" + DOLLAR_SIGN)) {
            stringToParse = "-" + stringToParse.substring(DOLLAR_SIGN.length() + 1);
        }
        this.origRawValue = Double.parseDouble(stringToParse);
        this.roundAmount = roundAmt;
        this.value = MathsUtils.roundDouble(this.origRawValue, this.roundAmount);
    }

    public double getRoundAmount() {
        return this.roundAmount;
    }

    public int getNumCents() {
        double value2DecPlaces = MathsUtils.roundDoubleToDecPlaces(this.value, 2);
        if (this.isZero()) {
            return 0;
        }
        if (this.value < 0.0) {
            return (int)(value2DecPlaces * 100.0 - 0.5);
        }
        if (this.value > 0.0) {
            return (int)(value2DecPlaces * 100.0 + 0.5);
        }
        throw new IllegalStateException("Non zero price was neither less than zero nor greater than zero... wtf? " + this.value);
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    public String toString(boolean addDollarsSign) {
        String str;
        double roundedValue = MathsUtils.roundDoubleToDecPlaces(this.value, 2);
        double abValue = Math.abs(roundedValue);
        if (abValue >= 1.0E7 || abValue < 0.001) {
            if (format.get() == null) {
                format.set(new DecimalFormat("0.00"));
            }
            str = format.get().format(abValue);
        } else {
            str = String.valueOf(abValue);
        }
        int pos = str.indexOf(46);
        if (pos == -1) {
            str = str + ".00";
        } else if (pos == str.length() - 1) {
            str = str + "00";
        } else if (pos == str.length() - 2) {
            str = str + "0";
        } else if (pos < str.length() - 3) {
            str = str.substring(0, pos + 3);
        }
        if (addDollarsSign) {
            str = DOLLAR_SIGN + str;
        }
        if (this.value < 0.0) {
            str = "-" + str;
        }
        if (str.equals("-" + DOLLAR_SIGN + "0.00")) {
            str = DOLLAR_SIGN + "0.00";
        }
        return str;
    }

    public String toString() {
        if (this.toStringValue == null) {
            this.toStringValue = this.toString(true);
        }
        return this.toStringValue;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Price) {
            Price comparePrice = (Price)obj;
            return comparePrice.getNumCents() == this.getNumCents();
        }
        return super.equals(obj);
    }

    public boolean approximatelyEquals(Price anotherPrice) {
        return anotherPrice != null ? Math.abs(anotherPrice.doubleValue() - this.value) <= EQUIVALENT_THRESHOLD : false;
    }

    public boolean greaterThan(Object obj) {
        return this.compareTo((Price)obj) > 0;
    }

    public boolean lessThan(Object obj) {
        return this.compareTo((Price)obj) < 0;
    }

    public int hashCode() {
        Double wrapper = new Double(this.value);
        return wrapper.hashCode();
    }

    public Price add(Price other) {
        if (other != null) {
            return new Price(this.value + other.value, this.roundAmount);
        }
        return this;
    }

    public Price subtract(Price other) {
        if (other != null) {
            return new Price(this.value - other.value, this.roundAmount);
        }
        return this;
    }

    public Price multiply(Price other) {
        if (other != null) {
            return new Price(this.value * other.value, this.roundAmount);
        }
        return this;
    }

    public Price multiply(Number number) {
        return this.multiply(number.doubleValue());
    }

    public Price multiply(SalesQuantity qty) {
        return this.multiply(qty.getValue());
    }

    public Price multiply(int multiplyBy) {
        return new Price(this.value * (double)multiplyBy, this.roundAmount);
    }

    public Price multiply(double multiplyBy) {
        return new Price(this.value * multiplyBy, this.roundAmount);
    }

    public Price divide(Price other) {
        if (other != null && !other.isZero()) {
            return new Price(this.value / other.value, this.roundAmount);
        }
        return this;
    }

    public Price divide(Number other) {
        if (other != null && other.doubleValue() != 0.0) {
            BigDecimal otherDecimal = BigDecimal.valueOf(other.doubleValue());
            return new Price(BigDecimal.valueOf(this.value).divide(otherDecimal, 20, RoundingMode.HALF_EVEN), this.roundAmount);
        }
        return this;
    }

    public Price divide(int divideBy) {
        if (divideBy != 0) {
            return new Price(this.value / (double)divideBy, this.roundAmount);
        }
        return this;
    }

    @Override
    public int compareTo(Price o) {
        if (this.value > o.value) {
            return 1;
        }
        if (this.value < o.value) {
            return -1;
        }
        return 0;
    }

    public boolean isZero() {
        double localValue = Math.abs(this.doubleValue());
        double diff = localValue - 0.005;
        return diff < 0.0;
    }

    public static Price parsePrice(String money) {
        return new Price(money, 0.01);
    }

    public static Price parsePrice(String money, double rounding) {
        return new Price(money, rounding);
    }

    public static void setDollarSign(String value) {
        if (value != null) {
            DOLLAR_SIGN = value;
        }
    }

    public static void setDefaultRounding(Double value) {
        if (value != null && value > 0.0 && value < 1.0) {
            DEFAULT_ROUND_AMOUNT = value;
        }
    }

    public Price abs() {
        return new Price(Math.abs(this.value), this.roundAmount);
    }

    public Price negate() {
        return new Price(this.value * -1.0, this.roundAmount);
    }

    public BigDecimal toBigDecimal() {
        try {
            return new BigDecimal(this.toString(false));
        }
        catch (NumberFormatException ex) {
            OrderMate.LOG.error("Could not format " + this.toString(false) + " as BigDecimal", (Throwable)ex);
            throw ex;
        }
    }

    public Price getAppliedRoundingAmt() {
        return new Price(this.doubleValue() - this.origRawValue, 0.01);
    }

    public Price getRawValueToOneCent() {
        return new Price(this.origRawValue, 0.01);
    }

    public double getOriginalRawValue() {
        return this.origRawValue;
    }
}

