/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import ordermate.OrderMate;

public class ProcessUtil {
    public static void runCmd(String command) throws IOException {
        Runtime.getRuntime().exec(new String[]{"cmd.exe", "/C", command});
    }

    public static int runCmdAndWait(String command) throws IOException {
        return ProcessUtil.runCmdAndWait(command, null, null);
    }

    public static void restartService(String serviceName) throws Exception {
        String filePath = ProcessUtil.createRestartBatchFile(serviceName);
        Process process = Runtime.getRuntime().exec(filePath);
        ProcessUtil.printProcessOutput(process);
        process.waitFor();
    }

    private static String createRestartBatchFile(String serviceName) {
        try {
            String serviceRestartFilePath = "c:\\temp\\" + serviceName + "Restart.bat";
            List<String> batchFileContent = Arrays.asList("@echo off", "net stop \"" + serviceName + "\"", "net start \"" + serviceName + "\"");
            Files.write(Paths.get(serviceRestartFilePath, new String[0]), batchFileContent, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            return serviceRestartFilePath;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void printProcessOutput(Process process) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((line = reader.readLine()) != null) {
            OrderMate.LOG.info("Windows Cmd: " + line);
        }
        BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        while ((line = errorReader.readLine()) != null) {
            OrderMate.LOG.info("Windows Cmd: " + line);
        }
    }

    public static int runCmdAndWait(String command, OutputStream stdOut, OutputStream errOut) throws IOException {
        return ProcessUtil.runCommandsAndWait(stdOut, errOut, "cmd.exe", "/C", command);
    }

    public static int runCommandsAndWait(OutputStream stdOut, OutputStream errOut, String ... commands) throws IOException {
        Process process = Runtime.getRuntime().exec(commands);
        try {
            StreamConsumer inputConsumer = new StreamConsumer(process.getInputStream(), false);
            if (stdOut != null) {
                inputConsumer.setOutputStream(stdOut);
            }
            StreamConsumer errorConsumer = new StreamConsumer(process.getErrorStream(), true);
            if (errOut != null) {
                errorConsumer.setOutputStream(errOut);
            }
            Thread input = new Thread((Runnable)inputConsumer, "Output Consumer");
            input.start();
            Thread error = new Thread((Runnable)errorConsumer, "Error Consumer");
            error.start();
            int result = process.waitFor();
            input.join();
            error.join();
            OrderMate.LOG.info("The result of process.waitFor :: " + result);
            return result;
        }
        catch (Throwable th) {
            OrderMate.LOG.error("Error in process", th);
            return -1;
        }
    }

    public static void runCommands(String ... commands) throws IOException {
        Runtime.getRuntime().exec(commands);
    }

    public static int execJavaProcess(Class clazz, List<String> args) throws IOException, InterruptedException {
        String javaHome = System.getProperty("java.home");
        String javaBin = javaHome + File.separator + "bin" + File.separator + "java";
        String classpath = System.getProperty("java.class.path");
        String className = clazz.getName();
        LinkedList<String> command = new LinkedList<String>();
        command.add(javaBin);
        command.add("-cp");
        command.add(classpath);
        command.add(className);
        if (args != null) {
            command.addAll(args);
        }
        ProcessBuilder builder = new ProcessBuilder(command);
        Process process = builder.inheritIO().start();
        process.waitFor();
        return process.exitValue();
    }

    public static void execJavaWSProcessImmediately(String path, List<String> args) throws IOException, InterruptedException {
        String javaHome = System.getProperty("java.home");
        String javawsBin = javaHome + File.separator + "bin" + File.separator + "javaws";
        LinkedList<String> command = new LinkedList<String>();
        command.add(javawsBin);
        if (args != null) {
            command.addAll(args);
        }
        command.add(path);
        new ProcessBuilder(command).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> makeAndRunBatchFile(String batchFileName, String batchFileString) {
        ArrayList<String> results = new ArrayList<String>();
        File batchFile = new File(batchFileName);
        if (!batchFile.getParentFile().exists()) {
            batchFile.getParentFile().mkdirs();
        }
        if (batchFile.exists()) {
            batchFile.delete();
        }
        boolean written = false;
        FileWriter writer = null;
        try {
            writer = new FileWriter(batchFile);
            writer.write(batchFileString);
            writer.flush();
            written = true;
        }
        catch (Exception ex) {
            results.add("(X) Couldn't create backup batch file");
            OrderMate.LOG.error("Cannot write to backup batch file", (Throwable)ex);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception ex) {
                    OrderMate.LOG.error("Can't even close it off", (Throwable)ex);
                }
            }
        }
        boolean outcome = false;
        if (written) {
            try {
                int result = ProcessUtil.runCmdAndWait(batchFile.toString());
                outcome = result == 0;
            }
            catch (Exception ex) {
                results.add("X) Problem running the backup batch file");
            }
            finally {
                batchFile.delete();
            }
        }
        if (!outcome) {
            results.add("(X) Batch unsuccessful");
        } else {
            results.add("(/) Batch successful");
        }
        return results;
    }

    static class StreamConsumer
    implements Runnable {
        private final InputStream stream;
        private final String lineSeparator = System.getProperty("line.separator");
        private final boolean error;
        private OutputStream output;

        StreamConsumer(InputStream stream, boolean error) {
            this.stream = stream;
            this.error = error;
        }

        void setOutputStream(OutputStream output) {
            this.output = output;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InputStreamReader inputReader = null;
            try {
                inputReader = new InputStreamReader(this.stream);
                BufferedReader reader = new BufferedReader(inputReader);
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if (this.output != null) {
                        this.output.write(line.getBytes());
                        this.output.write(this.lineSeparator.getBytes());
                        this.output.flush();
                    }
                    if (this.error) {
                        OrderMate.LOG.error(line);
                        continue;
                    }
                    OrderMate.LOG.info(line);
                }
            }
            catch (IOException ex) {
                OrderMate.LOG.info("Problem with reading process input buffer", (Throwable)ex);
            }
            finally {
                try {
                    if (inputReader != null) {
                        inputReader.close();
                    }
                }
                catch (Exception ex) {
                    OrderMate.LOG.warn("Couldn't close off the process pipes", (Throwable)ex);
                }
            }
        }
    }
}

