/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessor;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Stringifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class PropertiedObjectStringifier<T extends PropertiedObject>
implements Stringifier<T> {
    private PropertiedObject.Property[] props;

    @Override
    public String stringify(T object) {
        if (this.props == null) {
            this.props = object.getProperties().asArray();
        }
        StringBuilder SB = new StringBuilder();
        for (PropertiedObject.Property prop : this.props) {
            SB.append(prop.getName()).append("=");
            SB.append(this.toString(prop, object.getPropertyValue(prop)));
            SB.append(",");
        }
        return SB.toString();
    }

    public String[][] getDisplayableData(PropertiedObject propObject, PropertyAccessor listProp, PropertyAccessor activeProp, Comparator comp, String[] headers, PropertyAccessor ... displayableProps) {
        Object propertyValue;
        String[][] data = null;
        if (propObject != null && listProp != null && (propertyValue = listProp.resolveValue(propObject)) != null && propertyValue instanceof List && displayableProps != null) {
            ArrayList listValue = (ArrayList)propertyValue;
            int i = 0;
            boolean valid = true;
            data = new String[listValue.size()][displayableProps.length];
            if (headers != null && headers.length > 0) {
                data = new String[listValue.size() + 1][displayableProps.length];
                if (headers.length != displayableProps.length) {
                    valid = false;
                }
                for (int j = 0; j < headers.length; ++j) {
                    data[i][j] = headers[j];
                }
                ++i;
            }
            if (valid) {
                if (comp != null) {
                    listValue = new ArrayList(listValue);
                    Collections.sort(listValue, comp);
                }
                data = this.stringifyProperties(listValue, activeProp, data, i, displayableProps);
            }
        }
        return data;
    }

    private String[][] stringifyProperties(List listValue, PropertyAccessor activeProp, String[][] data, int counter, PropertyAccessor ... displayableProps) {
        int i = counter;
        for (int x = 0; x < listValue.size(); ++x) {
            String systemState;
            boolean display = true;
            if (activeProp != null && !(systemState = String.valueOf(activeProp.resolveValue(listValue.get(x)))).equalsIgnoreCase("active")) {
                display = false;
            }
            if (!display) continue;
            for (int j = 0; j < displayableProps.length; ++j) {
                if (displayableProps[j].getProperty().getType().equals(Date.class)) {
                    if (displayableProps[j].getProperty().getName().contains("Time")) {
                        data[i][j] = DateTimeUtils.getSimpleTimeFormat().format(displayableProps[j].resolveValue(listValue.get(x)));
                        continue;
                    }
                    data[i][j] = DateTimeUtils.getMediumDateFormat().format(displayableProps[j].resolveValue(listValue.get(x)));
                    continue;
                }
                data[i][j] = String.valueOf(displayableProps[j].resolveValue(listValue.get(x)));
            }
            ++i;
        }
        String[][] finalData = (String[][])Arrays.copyOf(data, i);
        return finalData;
    }

    private String toString(PropertiedObject.Property prop, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            StringBuilder SB = new StringBuilder();
            for (Object nextValue : (Collection)value) {
                SB.append(nextValue).append(",");
            }
            return SB.toString();
        }
        return String.valueOf(value);
    }
}

