/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util;

import java.io.IOException;
import java.io.InputStream;
import ordermate.OrderMate;

public class RegistryIO {
    public static final String HK_LM = "HKEY_LOCAL_MACHINE";

    public final String getString(String location, String key) {
        try {
            int spaceIndex;
            StringBuilder command = new StringBuilder("reg query \"");
            command.append(location).append("\" /v \"").append(key).append("\"");
            Process process = Runtime.getRuntime().exec(command.toString());
            ReadItIn reader = new ReadItIn(process.getInputStream());
            reader.start();
            process.waitFor();
            reader.join();
            String output = reader.getString();
            int indexOfRegType = output.indexOf("REG_");
            if (indexOfRegType <= 0) {
                return null;
            }
            for (int i = spaceIndex = indexOfRegType + 1; i < output.length(); ++i) {
                if (!Character.isWhitespace(output.charAt(i))) continue;
                spaceIndex = i;
                break;
            }
            String substring = output.substring(spaceIndex).trim();
            return substring;
        }
        catch (Exception e) {
            return null;
        }
    }

    public final Double getDouble(String location, String key) {
        String result = this.getString(location, key);
        if (result != null) {
            try {
                return Double.valueOf(result);
            }
            catch (NumberFormatException ex) {
                OrderMate.LOG.error(location + key + " is not a double");
            }
        }
        return null;
    }

    public final Integer getInt(String location, String key) {
        String result = this.getString(location, key);
        if (result != null) {
            try {
                return Integer.valueOf(result);
            }
            catch (NumberFormatException ex) {
                OrderMate.LOG.error(location + key + " is not an integer");
            }
        }
        return null;
    }

    static class ReadItIn
    extends Thread {
        private InputStream in;
        private StringBuilder SB;

        public ReadItIn(InputStream toRead) {
            this.in = toRead;
            this.SB = new StringBuilder();
        }

        @Override
        public void run() {
            try {
                int c;
                while ((c = this.in.read()) != -1) {
                    this.SB.append((char)c);
                }
            }
            catch (IOException e) {
                OrderMate.LOG.error("Cannot read in value from registry");
            }
        }

        public String getString() {
            return this.SB.toString();
        }
    }
}

