/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util;

import au.com.ordermate.util.Pair;
import au.com.ordermate.util.Stringifier;
import au.com.ordermate.util.ToStringifier;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ordermate.OrderMate;
import ordermate.internationalization.Internationalization;

public final class StringUtils {
    public static final String HALF = "Half";
    public static final String THIRD = "Third";
    public static final String QUARTER = "Quarter";
    private static final char[] lowercases = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f'};
    static final Pattern PATTERN_EMOJIS = Pattern.compile("[\ud83c\udc00-\ud83c\udfff]|[\ud83d\udc00-\ud83d\udfff]|[\u2600-\u27ff]", 194);
    private static final int[] ABN_WEIGHTING = new int[]{10, 1, 3, 5, 7, 9, 11, 13, 15, 17, 19};
    private static final String DEL = "DEL";
    private static final String[] CONTROL_STRINGS = new String[]{"NUL", "SOH", "STX", "ETX", "EOT", "ENQ", "ACK", "BEL", "BS ", "TAB", "LF ", "VT ", "FF ", "CR ", "SO ", "SI ", "DLE", "DC1", "DC2", "DC3", "DC4", "NAK", "SYN", "ETB", "CAN", "EM", "SUB", "ESC", "FS ", "GS ", "RS ", "US ", "SP "};
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    private static final char[] HEX_ARRAY_LOWER = "0123456789abcdef".toCharArray();
    public static final String ALL_WHITESPACE_CHARS = "\t\n\u000b\f\r \u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u0085\u1680\u2028\u2029\u205f\u3000\u00a0\u180e\u202f";

    public static boolean isNumeric(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isDisplayable(char c) {
        return c >= ' ' && c <= '~';
    }

    public static boolean isValidJavaIdentifierChars(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (StringUtils.isValidJavaIdentifierChar(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphaNumericIncludingSpace(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (StringUtils.isAlphaNumeric(str.charAt(i)) || Character.isSpaceChar(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphaNumeric(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (StringUtils.isAlphaNumeric(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (StringUtils.isNumeric(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphabetical(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (StringUtils.isAlphabetical(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidJavaIdentifierChar(char c) {
        return c == '_' || StringUtils.isAlphaNumeric(c);
    }

    public static boolean isAlphabetical(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public static boolean isUpperCase(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static boolean isLowerCase(char c) {
        return c >= 'a' && c <= 'z';
    }

    public static boolean isAlphaNumeric(char c) {
        return StringUtils.isNumeric(c) || StringUtils.isAlphabetical(c);
    }

    public static boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\u0000';
    }

    public static String stripQuotes(String text) {
        if (text.length() >= 2 && (text.charAt(0) == '\"' && text.charAt(text.length() - 1) == '\"' || text.charAt(0) == '\'' && text.charAt(text.length() - 1) == '\'')) {
            return text.substring(1, text.length() - 1);
        }
        return text;
    }

    public static boolean isCustomerString(String data) {
        return data.startsWith(Internationalization.getLiteralFor("DOLLAR_SIGN"));
    }

    public static String cleanStringForSQL(String text) {
        String txt = text;
        txt = txt.replace('\'', '`');
        txt = txt.replace('\\', '/');
        return txt;
    }

    public static String escapeStringForSQL(String text, boolean escapePercentage) {
        char[] charsToEscape = escapePercentage ? new char[]{'\'', '\"', '\\', '%'} : new char[]{'\'', '\"', '\\'};
        return StringUtils.escapeChars(text, charsToEscape);
    }

    public static String escapeSingleQuotes(String text) {
        return StringUtils.escapeChars(text, new char[]{'\''});
    }

    private static String escapeChars(String textToClean, char[] charsToEscape) {
        int escapeChar = 92;
        StringBuilder SB = new StringBuilder();
        for (int i = 0; i < textToClean.length(); ++i) {
            if (StringUtils.charIn(textToClean.charAt(i), charsToEscape)) {
                SB.append('\\');
                SB.append(textToClean.charAt(i));
                continue;
            }
            SB.append(textToClean.charAt(i));
        }
        return SB.toString();
    }

    private static boolean charIn(char a, char[] inThese) {
        for (char element : inThese) {
            if (element != a) continue;
            return true;
        }
        return false;
    }

    public static boolean isBefore(String string1, String string2) {
        String str1 = string1;
        String str2 = string2;
        boolean finished = false;
        boolean result = false;
        if (str1.equals("") || str2.equals("")) {
            return false;
        }
        str1 = str1.toLowerCase();
        str2 = str2.toLowerCase();
        for (int index = 0; index < str1.length() && index < str2.length() && !finished; ++index) {
            char c2;
            char c1 = str1.charAt(index);
            if (c1 < (c2 = str2.charAt(index))) {
                finished = true;
                result = true;
                continue;
            }
            if (c1 <= c2) continue;
            finished = true;
        }
        return result;
    }

    public static String removeDoubleQuotes(String str) {
        if (str == null || str.trim().length() == 0) {
            return "";
        }
        str = str.trim();
        String startRegEx = "^\"[\\p{ASCII}]*";
        String endRegEx = "[\\p{ASCII}]*\"$";
        StringBuilder sb = new StringBuilder(str);
        if (str.matches("^\"[\\p{ASCII}]*")) {
            sb.deleteCharAt(sb.indexOf("\""));
        }
        if (str.matches("[\\p{ASCII}]*\"$") && sb.lastIndexOf("\"") > -1) {
            sb.deleteCharAt(sb.lastIndexOf("\""));
        }
        return sb.toString();
    }

    public static String getCharacterDetails(String str) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c;
            if (i != 0) {
                buffer.append(' ');
            }
            if ((c = str.charAt(i)) <= ' ') {
                buffer.append(CONTROL_STRINGS[c]);
                continue;
            }
            if (c == '\u007f') {
                buffer.append(DEL);
                continue;
            }
            if (c > '\u007f') {
                buffer.append("#" + Integer.toHexString(c));
                continue;
            }
            buffer.append(c + "  ");
        }
        return buffer.toString();
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String bytesToHexLower(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY_LOWER[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY_LOWER[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String byteArrayToHexString(byte[] in) {
        byte ch = 0;
        if (in == null || in.length <= 0) {
            return null;
        }
        String[] pseudo = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
        StringBuffer out = new StringBuffer(in.length * 2);
        for (int i = 0; i < in.length; ++i) {
            ch = (byte)(in[i] & 0xF0);
            ch = (byte)(ch >>> 4);
            ch = (byte)(ch & 0xF);
            out.append(pseudo[ch]);
            ch = (byte)(in[i] & 0xF);
            out.append(pseudo[ch]);
        }
        String rslt = new String(out);
        return rslt;
    }

    private StringUtils() {
    }

    public static byte[] resizeArray(byte[] incoming, int sizeIncrease) {
        byte[] newArray = new byte[incoming.length + sizeIncrease];
        for (int i = 0; i < incoming.length; ++i) {
            newArray[i] = incoming[i];
        }
        return newArray;
    }

    public static String firstCharToUpperCase(String string) {
        char firstChar;
        String str = string;
        if (str.length() > 0 && StringUtils.isLowerCase(firstChar = str.charAt(0))) {
            int diff = 32;
            StringBuffer buf = new StringBuffer(str);
            buf.setCharAt(0, (char)(firstChar - diff));
            str = buf.toString();
        }
        return str;
    }

    public static String firstCharToLowerCase(String string) {
        char firstChar;
        String str = string;
        if (str.length() > 0 && StringUtils.isUpperCase(firstChar = str.charAt(0))) {
            int diff = 32;
            StringBuffer buf = new StringBuffer(str);
            buf.setCharAt(0, (char)(firstChar + diff));
            str = buf.toString();
        }
        return str;
    }

    public static byte[] removeBytesFromArray(byte[] sourceBytes, int[] bytesToRemove) {
        byte[] returnArray = new byte[sourceBytes.length - bytesToRemove.length];
        int position = 0;
        for (int i = 0; i < sourceBytes.length; ++i) {
            boolean ok = true;
            for (int element : bytesToRemove) {
                if (element != i) continue;
                ok = false;
            }
            if (!ok) continue;
            returnArray[position] = sourceBytes[i];
            ++position;
        }
        return returnArray;
    }

    public static boolean isSwipeCardString(String input) {
        return input.length() > 1 && StringUtils.isSwipeCardMarker(input.charAt(0));
    }

    public static boolean isSwipeCardMarker(char input) {
        return input == '%' || input == ';';
    }

    public static boolean isProximityReaderString(String input) {
        return input.length() > 1 && StringUtils.isProximityInputMarker(input.charAt(0));
    }

    public static boolean isProximityInputMarker(char input) {
        return input == '!';
    }

    public static String formatSwipeCardForDisplay(String incoming) {
        String returnString = incoming;
        if (returnString.startsWith("%")) {
            returnString = returnString.substring(1, returnString.length());
        }
        if (returnString.startsWith("ordermate-")) {
            returnString = returnString.substring(returnString.lastIndexOf("-") + 1, returnString.length());
        }
        if (returnString.endsWith("?")) {
            returnString = returnString.substring(0, returnString.length() - 1);
        }
        return returnString;
    }

    public static String removePhoneNumberDashes(String inputNumber) {
        StringBuilder SB = new StringBuilder();
        for (int i = 0; i < inputNumber.length(); ++i) {
            if (!Character.isDigit(inputNumber.charAt(i))) continue;
            SB.append(inputNumber.charAt(i));
        }
        return SB.toString();
    }

    public static String removeChar(String str, char c) {
        int cPos = str.indexOf(c);
        int sLen = str.length();
        if (cPos == -1) {
            return str;
        }
        if (cPos == 0) {
            String substr = str.substring(1, sLen);
            return StringUtils.removeChar(substr, c);
        }
        if (cPos == sLen - 1) {
            return str.substring(0, sLen - 1);
        }
        String substr1 = str.substring(0, cPos);
        String substr2 = str.substring(cPos + 1, sLen);
        String substr = substr1.concat(substr2);
        return StringUtils.removeChar(substr, c);
    }

    public static String arrayToString(Object[] array) {
        StringBuffer buffer = new StringBuffer();
        buffer.append('[');
        for (int i = 0; i < array.length; ++i) {
            buffer.append(array[i]);
            if (i >= array.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append(']');
        return buffer.toString();
    }

    public static String[] stringListToArray(List theList) {
        String[] theArray = new String[theList.size()];
        int count = 0;
        Iterator it = theList.iterator();
        while (it.hasNext()) {
            String current;
            theArray[count] = current = (String)it.next();
            ++count;
        }
        return theArray;
    }

    public static String shorten(String toCut, int length) {
        if (toCut.length() > length) {
            return toCut.substring(0, length);
        }
        return toCut;
    }

    public static String leftPad(String strToPad, int length, char padChar) {
        String toPad = strToPad;
        int i = 0;
        while (i < length - toPad.length()) {
            toPad = padChar + toPad;
        }
        return toPad;
    }

    public static String rightPad(String strToPad, int length, char padChar) {
        StringBuilder SB = new StringBuilder(strToPad);
        int i = 0;
        while (i < length - SB.length()) {
            SB.append(padChar);
        }
        return SB.toString();
    }

    public static String readFromStream(InputStream readFrom, int endOfMessage) throws IOException {
        StringBuilder input = new StringBuilder();
        int currentInput = readFrom.read();
        while (currentInput != endOfMessage) {
            input.append((char)currentInput);
            currentInput = readFrom.read();
        }
        return input.toString();
    }

    public static String readFromStream(InputStream readFrom, int endOfMessage, int maxSize) throws IOException {
        StringBuilder input = new StringBuilder();
        int currentInput = readFrom.read();
        for (int sizeCounter = maxSize; currentInput != endOfMessage && sizeCounter > 0; --sizeCounter) {
            input.append((char)currentInput);
            currentInput = readFrom.read();
        }
        return input.toString();
    }

    public static String capitalize(String theString) {
        StringBuilder SB = new StringBuilder();
        for (int i = 0; i < theString.length(); ++i) {
            SB.append(Character.toUpperCase(theString.charAt(i)));
        }
        return SB.toString();
    }

    public static String convertToLowerCase(String theString) {
        StringBuilder SB = new StringBuilder();
        for (int i = 0; i < theString.length(); ++i) {
            SB.append(Character.toLowerCase(theString.charAt(i)));
        }
        return SB.toString();
    }

    public static int countMatches(String str, String sub) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(sub)) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        while ((idx = str.indexOf(sub, idx)) != -1) {
            ++count;
            idx += sub.length();
        }
        return count;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String camelCaseToDisplayable(String name) {
        StringBuilder builder = new StringBuilder();
        name = name.trim();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c) && i != 0) {
                builder.append(" ");
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static String camelCaseToDisplayableAcronyms(String name) {
        StringBuilder builder = new StringBuilder();
        name = name.trim();
        boolean upper = true;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i != 0) {
                    if (i < name.length() - 1 && Character.isLowerCase(name.charAt(i + 1))) {
                        builder.append(" ");
                    } else if (!upper) {
                        builder.append(" ");
                    }
                }
                upper = true;
            } else {
                upper = false;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static String underscoreToDisplayable(String toConvert) {
        String lowerCase = toConvert.toLowerCase();
        String[] splits = lowerCase.split("_");
        String toMakePretty = splits[0];
        toMakePretty = StringUtils.firstCharToUpperCase(toMakePretty);
        StringBuilder SB = new StringBuilder(toMakePretty);
        for (int i = 1; i < splits.length; ++i) {
            toMakePretty = splits[i];
            toMakePretty = StringUtils.firstCharToUpperCase(toMakePretty);
            SB.append(" ").append(toMakePretty);
        }
        return SB.toString();
    }

    public static String escapeSQLColumnName(String colName) {
        String column = StringUtils.stripQuotes(colName);
        if (column.startsWith("(") && column.endsWith(")")) {
            return column;
        }
        if (column.contains(" ")) {
            char quoteChar = StringUtils.getQuoteChar(column);
            return quoteChar + column + quoteChar;
        }
        return column;
    }

    private static char getQuoteChar(String colName) {
        return colName.contains("'") ? (char)'`' : '\'';
    }

    public static boolean startsWithIgnoreCase(String toTest, String prefix) {
        if (prefix == null) {
            return true;
        }
        int length = prefix.length();
        if (toTest == null || toTest.length() < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            char c2;
            char c1 = toTest.charAt(i);
            if (c1 == (c2 = prefix.charAt(i))) continue;
            if (c1 <= '\u007f') {
                c1 = lowercases[c1];
            }
            if (c2 <= '\u007f') {
                c2 = lowercases[c2];
            }
            if (c1 == c2) continue;
            return false;
        }
        return true;
    }

    public static int indexIgnoreCase(String toTest, String substring) {
        if (substring == null || toTest == null) {
            return -1;
        }
        return StringUtils.asciiToLowerCase(toTest).indexOf(StringUtils.asciiToLowerCase(substring));
    }

    public static String asciiToLowerCase(String s) {
        char[] c = null;
        int i = s.length();
        while (i-- > 0) {
            char c2;
            char c1 = s.charAt(i);
            if (c1 > '\u007f' || c1 == (c2 = lowercases[c1])) continue;
            c = s.toCharArray();
            c[i] = c2;
            break;
        }
        if (c != null) {
            while (i-- > 0) {
                if (c[i] > 127) continue;
                c[i] = lowercases[c[i]];
            }
        }
        return c == null ? s : new String(c);
    }

    public static List<String> splitToList(String toSplit, String splitBy) {
        ArrayList<String> newList = new ArrayList<String>();
        if (toSplit != null && !toSplit.trim().isEmpty()) {
            for (String string : toSplit.split(splitBy)) {
                newList.add(string);
            }
        }
        return newList;
    }

    public static Pair<String, String> splitToPair(String toSplit, String separator) {
        int index = toSplit.indexOf(separator);
        if (index < 0) {
            if (toSplit.isEmpty()) {
                return null;
            }
            index = toSplit.length();
        }
        Pair<String, Object> pair = null;
        try {
            String key = toSplit.substring(0, index);
            pair = index < toSplit.length() ? new Pair<String, String>(key, toSplit.substring(index + 1, toSplit.length())) : new Pair<String, Object>(key, null);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot wrangle pair string ", (Throwable)ex);
        }
        return pair;
    }

    public static List<Pair<String, String>> splitToPairs(String toSplit, String valueSeparator, String pairSeparator) {
        ArrayList<Pair<String, String>> pairs = new ArrayList<Pair<String, String>>();
        List<String> splits = StringUtils.splitToList(toSplit, pairSeparator);
        for (String nextSplit : splits) {
            Pair<String, String> pair = StringUtils.splitToPair(nextSplit, valueSeparator);
            if (pair == null) continue;
            pairs.add(pair);
        }
        return pairs;
    }

    public static Set<String> splitToSet(String toSplit, String separator) {
        return new HashSet<String>(Arrays.asList(toSplit.split(separator)));
    }

    public static String mergePairs(List<Pair<?, ?>> pairs, String valueSeparator, String pairSeparator) {
        StringBuilder SB = new StringBuilder();
        for (int i = 0; i < pairs.size(); ++i) {
            SB.append(String.valueOf(pairs.get(i).getKey())).append(valueSeparator).append(String.valueOf(pairs.get(i).getValue()));
            if (i >= pairs.size() - 1) continue;
            SB.append(pairSeparator);
        }
        return SB.toString();
    }

    public static String mergeWithSeparator(Collection<String> values, String separator) {
        if (values.size() == 0) {
            return "";
        }
        StringBuilder SB = new StringBuilder();
        for (String nextValue : values) {
            SB.append(nextValue);
            SB.append(separator);
        }
        int sepLength = separator.length();
        if (SB.length() >= sepLength) {
            SB.replace(SB.length() - sepLength, SB.length(), "");
        }
        return SB.toString();
    }

    public static <T> String mergeToStringWithSeparator(Collection<T> values, String separator, Stringifier<T> stringifier) {
        if (values.size() == 0) {
            return "";
        }
        if (stringifier == null) {
            stringifier = new ToStringifier();
        }
        StringBuilder SB = new StringBuilder();
        for (T nextValue : values) {
            SB.append(stringifier.stringify(nextValue));
            SB.append(separator);
        }
        int sepLength = separator.length();
        if (SB.length() >= sepLength) {
            SB.replace(SB.length() - sepLength, SB.length(), "");
        }
        return SB.toString();
    }

    public static List<String> readLinesFromStream(InputStream in, boolean ignoreBlank) throws IOException {
        InputStreamReader streamReader = new InputStreamReader(in);
        BufferedReader reader = new BufferedReader(streamReader);
        ArrayList<String> lines = new ArrayList<String>();
        String line = reader.readLine();
        while (line != null) {
            if (!ignoreBlank || !line.trim().isEmpty()) {
                lines.add(line);
            }
            line = reader.readLine();
        }
        return lines;
    }

    public static File getLocalFile(String prefix, Class localClass, String filename) throws IOException {
        String name = localClass.getPackage().getName();
        StringBuilder SB = new StringBuilder();
        if (prefix != null) {
            SB.append(prefix).append(File.separator);
        }
        SB.append(name.replace(".", File.separator)).append(File.separator).append(filename);
        File file = new File(SB.toString());
        return file;
    }

    public static String readInTextFile(File input, String encodingName) throws IOException {
        if (input == null || !input.exists()) {
            return null;
        }
        StringBuilder SB = new StringBuilder();
        FileInputStream fin = null;
        InputStreamReader isin = null;
        BufferedReader in = null;
        try {
            fin = new FileInputStream(input);
            isin = encodingName == null ? new InputStreamReader(fin) : new InputStreamReader((InputStream)fin, encodingName);
            in = new BufferedReader(isin);
            String line = in.readLine();
            while (line != null) {
                SB.append(line);
                line = in.readLine();
                if (line == null) continue;
                SB.append("\r\n");
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            if (fin != null) {
                try {
                    if (in != null) {
                        in.close();
                    }
                    isin.close();
                    fin.close();
                }
                catch (IOException ex) {
                    OrderMate.LOG.error("Couldn't close off the file input stream.", (Throwable)ex);
                }
            }
        }
        return SB.toString();
    }

    public static String readInTextFile(String filename) throws IOException {
        return StringUtils.readInTextFile(new File(filename));
    }

    public static String readInTextFile(File input) throws IOException {
        return StringUtils.readInTextFile(input, null);
    }

    public static void writeTextToFile(File output, String text) throws IOException {
        if (output != null && text != null) {
            FileOutputStream fout = null;
            PrintWriter out = null;
            try {
                fout = new FileOutputStream(output);
                out = new PrintWriter(fout);
                out.write(text);
                out.flush();
                fout.flush();
            }
            catch (IOException ex) {
                throw ex;
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                        fout.close();
                    }
                    catch (IOException ex) {
                        OrderMate.LOG.error("Couldn't close off the file output stream.", (Throwable)ex);
                    }
                }
            }
        }
    }

    public static String eachWordToUpperCase(String arg) {
        List<String> words = StringUtils.splitToList(arg, " ");
        StringBuilder sb = new StringBuilder();
        if (words.isEmpty()) {
            return "";
        }
        sb.append(StringUtils.firstCharToUpperCase(words.get(0)));
        for (int i = 1; i < words.size(); ++i) {
            sb.append(" ");
            sb.append(StringUtils.firstCharToUpperCase(words.get(i)));
        }
        return sb.toString();
    }

    public static String trimCustom(String toTrim, String listOfCharsToTrim) {
        int st;
        int len = toTrim.length();
        int off = 0;
        char[] val = toTrim.toCharArray();
        for (st = 0; st < len && listOfCharsToTrim.contains("" + val[off + st]); ++st) {
        }
        while (st < len && listOfCharsToTrim.contains("" + val[off + len - 1])) {
            --len;
        }
        return st > 0 || len < toTrim.length() ? toTrim.substring(st, len) : toTrim;
    }

    public static String trimCustom(String toTrim) {
        return StringUtils.trimCustom(toTrim, ALL_WHITESPACE_CHARS);
    }

    public static boolean isUTFCharacter(int character) {
        return character == 65279;
    }

    public static boolean isUtf8(InputStreamReader in) throws IOException {
        return StringUtils.isUTFCharacter(in.read());
    }

    public static InputStreamReader createAppropriateReader(String fileName) throws IOException {
        FileInputStream fin = new FileInputStream(fileName);
        InputStreamReader reader = new InputStreamReader((InputStream)fin, "UTF-8");
        if (StringUtils.isUtf8(reader)) {
            return reader;
        }
        reader.close();
        return new InputStreamReader(new FileInputStream(fileName));
    }

    public static String removeAllWhiteSpace(String str) {
        if (str != null) {
            return str.replaceAll("\\s+", "");
        }
        return str;
    }

    public static String removeHTMLTags(String toFormat) {
        return toFormat.replaceAll("\\<[^>]*>", "");
    }

    public static boolean containsIgnoreCase(String bigString, String subString) {
        return Pattern.compile(Pattern.quote(subString), 2).matcher(bigString).find();
    }

    public static Double pullDoubleFromString(String containsDouble) {
        String regexp = "[-+]?(\\b[0-9]+(\\.[0-9]*)?|\\.[0-9]+)([eE][-+]?[0-9]+\\b)?";
        Matcher matcher = Pattern.compile("[-+]?(\\b[0-9]+(\\.[0-9]*)?|\\.[0-9]+)([eE][-+]?[0-9]+\\b)?").matcher(containsDouble);
        if (!matcher.find()) {
            return null;
        }
        String result = matcher.group();
        Double toReturn = null;
        try {
            toReturn = new Double(result);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return toReturn;
    }

    public static String nullToEmpty(String str) {
        return str != null ? str : "";
    }

    public static String reverseForeignCharSequence(String value) {
        if (value == null) {
            return "".intern();
        }
        char[] chars = new char[value.length()];
        int reverseStart = -1;
        for (int i = 0; i < chars.length; ++i) {
            char character = value.charAt(i);
            if (Character.getDirectionality(character) == 2 || Character.isWhitespace(character)) {
                if (reverseStart != -1) continue;
                reverseStart = i;
                continue;
            }
            if (reverseStart > -1) {
                int count = 0;
                for (int j = i - 1; j >= reverseStart; --j) {
                    chars[reverseStart + count] = value.charAt(j);
                    ++count;
                }
                reverseStart = -1;
                chars[i] = character;
                continue;
            }
            chars[i] = character;
        }
        if (reverseStart > -1) {
            int count = 0;
            for (int j = chars.length - 1; j >= reverseStart; --j) {
                chars[reverseStart + count] = value.charAt(j);
                ++count;
            }
        }
        return String.valueOf(chars);
    }

    public static String splitForeignChars(String value, String split, Pair<Character, Character> ignorePair) {
        char[] chars = value.toCharArray();
        if (chars.length < 2) {
            return value;
        }
        boolean ideoGraphic = !StringUtils.isBasicLatin(chars[0]);
        StringBuilder SB = new StringBuilder();
        boolean ignoring = false;
        for (int i = 0; i < chars.length; ++i) {
            Character character = Character.valueOf(chars[i]);
            if (ignorePair != null && ((Character)ignorePair.key).equals(character)) {
                ignoring = true;
            }
            if (!ignoring && ideoGraphic != !StringUtils.isBasicLatin(character.charValue()) && !StringUtils.isWhiteSpace(character.charValue())) {
                ideoGraphic = !ideoGraphic;
                SB.append(split);
            }
            SB.append(character);
            if (ignorePair == null || !((Character)ignorePair.value).equals(character)) continue;
            ignoring = false;
        }
        return SB.toString();
    }

    public static boolean isBasicLatin(char c) {
        return Character.UnicodeBlock.of(c) == Character.UnicodeBlock.BASIC_LATIN;
    }

    public static boolean isChineseJapaneseKorean(char c) {
        return Character.UnicodeBlock.of(c) == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS;
    }

    public static boolean isArabic(char c) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        return block == Character.UnicodeBlock.ARABIC || block == Character.UnicodeBlock.ARABIC_PRESENTATION_FORMS_A || block == Character.UnicodeBlock.ARABIC_PRESENTATION_FORMS_B;
    }

    public static String removeEmojis(String text) {
        if (StringUtils.isEmpty(text)) {
            return text;
        }
        Matcher emojiMatcher = PATTERN_EMOJIS.matcher(text);
        return emojiMatcher.replaceAll("").trim();
    }

    public static String cleanHtmlText(String text) {
        String toReturn = text.replaceAll("&[^;]+;", "");
        toReturn = toReturn.replaceAll("<[^>]+>", " ");
        toReturn = toReturn.trim();
        toReturn = toReturn.replaceAll(" +", " ");
        return toReturn;
    }

    public static String sanitiseStringForWindowsFileSystem(String str) {
        String[] badChars = new String[]{"<", ">", ":", "\"", "/", "\\", "|", "?", "*", "'"};
        String result = str;
        for (String badChar : badChars) {
            result = result.replace(badChar, "");
        }
        return result;
    }

    public static String removeSpecialCharacters(String str) {
        if (StringUtils.isEmpty(str)) {
            return "";
        }
        return str.replaceAll("[^a-zA-Z0-9]", "");
    }

    public static String clampStringRetainWordsWithMaxChars(String str, int maxChars) {
        if (StringUtils.isEmpty(str) || maxChars < 1) {
            OrderMate.LOG.warn("Invalid input string " + str + " OR maximum chars input " + maxChars);
            return "";
        }
        String result = "";
        int wordCount = 0;
        for (String word : str.split(" ")) {
            if (wordCount != 0 && result.length() + word.length() > maxChars) break;
            result = result + word;
            ++wordCount;
        }
        return result.length() <= maxChars ? result : result.substring(0, maxChars);
    }

    public static boolean isValidABN(String abn) {
        if (!StringUtils.isEmpty(abn) && StringUtils.isNumeric(abn) && abn.length() == 11) {
            int checksum = 0;
            for (int i = 0; i < abn.length(); ++i) {
                int positionValue = Character.digit(abn.charAt(i), 10);
                if (i == 0) {
                    --positionValue;
                }
                checksum += positionValue * ABN_WEIGHTING[i];
            }
            return checksum % 89 == 0;
        }
        return false;
    }

    public static boolean areStringsEqualIgnoringCase(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 != null && s2 != null) {
            return s1.equalsIgnoreCase(s2);
        }
        return false;
    }

    public static String getInterString(String toModify, String startMarker, String endMarker) {
        int endIndex;
        int startIndex = toModify.indexOf(startMarker);
        if (startIndex >= 0 && (endIndex = toModify.indexOf(endMarker, startIndex += startMarker.length())) > 0) {
            return toModify.substring(startIndex, endIndex);
        }
        return null;
    }

    public static List<String> getInterStringList(String toModify, String startMarker, String endMarker) {
        int startIndex;
        ArrayList<String> timeStringList = new ArrayList<String>();
        while ((startIndex = toModify.indexOf(startMarker)) >= 0) {
            int startIndex1 = startIndex + startMarker.length();
            int endIndex = toModify.indexOf(endMarker, startIndex1);
            if (endIndex > 0) {
                timeStringList.add(toModify.substring(startIndex1, endIndex));
            }
            int endIndex1 = endIndex + endMarker.length();
            toModify = toModify.replace(toModify.substring(startIndex, endIndex1), "");
        }
        return timeStringList;
    }

    public static String ensureEndsWith(String aString, String suffix) {
        if (aString != null && !aString.endsWith(suffix)) {
            return aString + suffix;
        }
        return aString;
    }

    public static String scramble(String toScramble, int times) {
        if (toScramble.length() < 2) {
            return toScramble;
        }
        char[] bytes = toScramble.toCharArray();
        for (int i = 0; i < times; ++i) {
            int second;
            int first;
            while ((first = (int)(Math.random() * (double)toScramble.length())) == (second = (int)(Math.random() * (double)toScramble.length()))) {
            }
            char temp = bytes[first];
            bytes[first] = bytes[second];
            bytes[second] = temp;
        }
        return new String(bytes);
    }
}

