/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class TimeLength
implements Serializable,
Comparable<TimeLength> {
    private long rawMillis;
    private Map<TimeParams, Long> timeValues = new HashMap<TimeParams, Long>();
    private Map<TimeParams, String> formatMap = new HashMap<TimeParams, String>();
    private List<TimeParams> sequence = new ArrayList<TimeParams>();
    private Map<TimeParams, Boolean> addLeadingZeros = new HashMap<TimeParams, Boolean>();
    private boolean showZeroFields = false;
    private static int SECONDS_MILLI_FACTOR = 1000;
    private static int DAY_HOUR_FACTOR = 24;
    private static int HOUR_MIN_FACTOR = 60;
    private static int MIN_SECONDS_FACTOR = 60;

    public TimeLength(long rawMilliseconds) {
        this.rawMillis = rawMilliseconds;
        this.setValue(TimeParams.MILLISECONDS, 0L);
        this.setValue(TimeParams.DAYS, 0L);
        this.setValue(TimeParams.HOURS, 0L);
        this.setValue(TimeParams.MINUTES, 0L);
        this.setValue(TimeParams.SECONDS, 0L);
        Collections.addAll(this.sequence, TimeParams.DAYS, TimeParams.HOURS, TimeParams.MINUTES, TimeParams.SECONDS, TimeParams.MILLISECONDS);
        this.setParamFormat(TimeParams.DAYS, "");
        this.setParamFormat(TimeParams.HOURS, "");
        this.setParamFormat(TimeParams.MINUTES, "");
        this.setParamFormat(TimeParams.SECONDS, "");
        this.setParamFormat(TimeParams.MILLISECONDS, "");
    }

    private void setValue(TimeParams param, Long value) {
        this.timeValues.put(param, value);
    }

    public void setSequence(List<TimeParams> newSequence) {
        this.sequence = newSequence;
    }

    public void setSequence(TimeParams ... newSequence) {
        this.sequence.clear();
        Collections.addAll(this.sequence, newSequence);
    }

    public void setParamFormat(TimeParams param, String newFormat) {
        this.formatMap.put(param, newFormat);
    }

    public void setLeadingZeros(TimeParams param, boolean addLeadingZeros) {
        this.addLeadingZeros.put(param, addLeadingZeros);
    }

    public void setShowZeroFields(boolean toSet) {
        this.showZeroFields = toSet;
    }

    public Long getRawMillis() {
        return this.rawMillis;
    }

    public String toString() {
        StringBuilder SB = new StringBuilder();
        this.buildValues();
        for (TimeParams param : this.sequence) {
            if (!this.showZeroFields && this.timeValues.get((Object)param) <= 0L) continue;
            if (this.addLeadingZeros.get((Object)param) != null && this.addLeadingZeros.get((Object)param).booleanValue()) {
                String toAppend = this.timeValues.get((Object)param).toString();
                while (toAppend.length() < param.getLength().length()) {
                    toAppend = "0" + toAppend;
                }
                SB.append(toAppend);
            } else {
                SB.append(this.timeValues.get((Object)param));
            }
            SB.append(this.formatMap.get((Object)param));
        }
        return SB.toString();
    }

    private void buildValues() {
        if (this.sequence.contains((Object)TimeParams.DAYS)) {
            this.setValue(TimeParams.DAYS, TimeUnit.MILLISECONDS.toDays(this.rawMillis));
        }
        if (this.sequence.contains((Object)TimeParams.HOURS)) {
            this.setValue(TimeParams.HOURS, TimeUnit.MILLISECONDS.toHours(this.rawMillis) - TimeUnit.DAYS.toHours(this.timeValues.get((Object)TimeParams.DAYS)));
        }
        if (this.sequence.contains((Object)TimeParams.MINUTES)) {
            this.setValue(TimeParams.MINUTES, TimeUnit.MILLISECONDS.toMinutes(this.rawMillis) - TimeUnit.DAYS.toMinutes(this.timeValues.get((Object)TimeParams.DAYS)) - TimeUnit.HOURS.toMinutes(this.timeValues.get((Object)TimeParams.HOURS)));
        }
        if (this.sequence.contains((Object)TimeParams.SECONDS)) {
            this.setValue(TimeParams.SECONDS, TimeUnit.MILLISECONDS.toSeconds(this.rawMillis) - TimeUnit.DAYS.toSeconds(this.timeValues.get((Object)TimeParams.DAYS)) - TimeUnit.HOURS.toSeconds(this.timeValues.get((Object)TimeParams.HOURS)) - TimeUnit.MINUTES.toSeconds(this.timeValues.get((Object)TimeParams.MINUTES)));
        }
        if (this.sequence.contains((Object)TimeParams.MILLISECONDS)) {
            this.setValue(TimeParams.MILLISECONDS, -TimeUnit.DAYS.toMillis(this.timeValues.get((Object)TimeParams.DAYS)) - TimeUnit.HOURS.toMillis(this.timeValues.get((Object)TimeParams.HOURS)) - TimeUnit.MINUTES.toMillis(this.timeValues.get((Object)TimeParams.MINUTES)) - TimeUnit.SECONDS.toMillis(this.timeValues.get((Object)TimeParams.SECONDS)));
        }
    }

    @Override
    public int compareTo(TimeLength o) {
        return this.getRawMillis().compareTo(o.getRawMillis());
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof TimeLength)) {
            return false;
        }
        return ((TimeLength)other).getRawMillis() == this.getRawMillis();
    }

    static /* synthetic */ int access$000() {
        return SECONDS_MILLI_FACTOR;
    }

    static /* synthetic */ int access$100() {
        return MIN_SECONDS_FACTOR;
    }

    static /* synthetic */ int access$200() {
        return HOUR_MIN_FACTOR;
    }

    static /* synthetic */ int access$300() {
        return DAY_HOUR_FACTOR;
    }

    public static enum TimeParams {
        MILLISECONDS(TimeLength.access$000()),
        SECONDS(TimeLength.access$100()),
        MINUTES(TimeLength.access$200()),
        HOURS(TimeLength.access$300()),
        DAYS(Integer.MAX_VALUE);

        int maxLength;

        private TimeParams(int length) {
            this.maxLength = length;
        }

        public String getLength() {
            return String.valueOf(this.maxLength);
        }
    }
}

