/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util;

import au.com.ordermate.util.ProcessUtil;
import au.com.ordermate.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.List;
import ordermate.LogoffCallback;
import ordermate.OrderMate;

public class WindowsUtils {
    private static void logMessage(String message) {
        OrderMate.LOG.info(message);
    }

    public static void safeLogoffUser(String username, LogoffCallback callback) {
        if (username == null) {
            OrderMate.LOG.warn("Cannot log off user with null username");
            if (callback != null) {
                callback.onLogoffResult(true);
            }
            return;
        }
        WindowsUtils.logMessage("UserName : " + username + " System.getProperty : " + System.getProperty("user.name"));
        if (username.equals(System.getProperty("user.name"))) {
            OrderMate.LOG.warn("Will not log off current user " + username);
            if (callback != null) {
                callback.onLogoffResult(true);
            }
            return;
        }
        WindowsUtils.logOffUser(username, callback);
    }

    public static void logOffUser(String username, LogoffCallback callback) {
        WindowsUtils.logMessage("WindowsUtils :: logOffUser :: " + username);
        if (!WindowsUtils.callLogoff(username, "query session", "logoff ")) {
            OrderMate.LOG.info("32 Bit logoff didn't work, trying 64 bit");
            String systemRoot = System.getenv("SystemRoot");
            String sysNativeFolder = systemRoot + "\\sysnative";
            String queryUserCmd = systemRoot + "\\sysnative\\quser.exe";
            String logOffCmd = systemRoot + "\\sysnative\\logoff.exe ";
            File queryCmd = new File(sysNativeFolder);
            WindowsUtils.logMessage("WindowsUtils :: logOffUser :: " + queryCmd.exists());
            if (!queryCmd.exists()) {
                queryUserCmd = systemRoot + "\\System32\\quser.exe";
                logOffCmd = systemRoot + "\\System32\\logoff.exe ";
            }
            callback.onLogoffResult(WindowsUtils.callLogoff(username, queryUserCmd, logOffCmd));
        } else if (callback != null) {
            callback.onLogoffResult(true);
        }
    }

    public static boolean safeLogoffUser(String username) {
        if (username == null) {
            OrderMate.LOG.warn("Cannot log off user with null username");
            return true;
        }
        WindowsUtils.logMessage("UserName : " + username + " System.getProperty : " + System.getProperty("user.name"));
        if (username.equals(System.getProperty("user.name"))) {
            OrderMate.LOG.warn("Will not log off current user " + username);
            return true;
        }
        return WindowsUtils.logOffUser(username);
    }

    public static boolean logOffUser(String username) {
        WindowsUtils.logMessage("WindowsUtils :: logOffUser :: " + username);
        if (!WindowsUtils.callLogoff(username, "query session", "logoff ")) {
            OrderMate.LOG.info("32 Bit logoff didn't work, trying 64 bit");
            String systemRoot = System.getenv("SystemRoot");
            String sysNativeFolder = systemRoot + "\\sysnative";
            String queryUserCmd = systemRoot + "\\sysnative\\quser.exe";
            String logOffCmd = systemRoot + "\\sysnative\\logoff.exe ";
            File queryCmd = new File(sysNativeFolder);
            WindowsUtils.logMessage("WindowsUtils :: logOffUser :: " + queryCmd.exists());
            if (!queryCmd.exists()) {
                queryUserCmd = systemRoot + "\\System32\\quser.exe";
                logOffCmd = systemRoot + "\\System32\\logoff.exe ";
            }
            return WindowsUtils.callLogoff(username, queryUserCmd, logOffCmd);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean callLogoff(String username, String queryCmd, String loggoffCmd) {
        WindowsUtils.logMessage("WindowsUtils :: callLogoff :: userName : " + username + " queryCmd : " + queryCmd + " logOffCmd : " + loggoffCmd);
        File tempDir = WindowsUtils.getTempDir();
        WindowsUtils.logMessage("TempDir : " + tempDir.toString());
        File batchFile = new File(tempDir + "\\QueryUser.bat");
        WindowsUtils.logMessage("BatchFile : " + batchFile.toString());
        try {
            StringUtils.writeTextToFile(batchFile, queryCmd);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ByteArrayOutputStream eout = new ByteArrayOutputStream();
            int result = ProcessUtil.runCmdAndWait(batchFile.toString(), bout, eout);
            WindowsUtils.logMessage("Result after QuerUser.bat :: execution : " + result);
            bout.close();
            if (result == 0) {
                int userId = WindowsUtils.interpretUser(username, new String(bout.toByteArray()));
                if (userId > 0) {
                    StringUtils.writeTextToFile(batchFile, loggoffCmd + userId);
                    bout = new ByteArrayOutputStream();
                    eout = new ByteArrayOutputStream();
                    result = ProcessUtil.runCmdAndWait(batchFile.toString(), bout, eout);
                    boolean bl = result == 0;
                    return bl;
                }
                WindowsUtils.logMessage("Cannot find user to logoff " + username);
                boolean bl = false;
                return bl;
            }
            WindowsUtils.logMessage("WindowUtils Error is  : " + new String(eout.toByteArray()));
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot log off user", (Throwable)ex);
        }
        finally {
            batchFile.delete();
        }
        WindowsUtils.logMessage("WindowsUtils :: callLogoff :: return false");
        return false;
    }

    static int interpretUser(String username, String userString) {
        String USERNAME = "USERNAME";
        String ID = "ID";
        List<String> rows = StringUtils.splitToList(userString, "\n");
        String header = rows.get(0);
        for (String row : rows) {
            WindowsUtils.logMessage("Row : " + row);
            if (!row.toUpperCase().contains("USERNAME")) continue;
            header = row.trim();
            break;
        }
        WindowsUtils.logMessage("Header : " + header);
        int userIndex = -1;
        int idIndex = -1;
        int count = 0;
        for (String nextSplit : header.trim().split("\\s+")) {
            if ("USERNAME".equals(nextSplit)) {
                userIndex = count;
            } else if ("ID".equals(nextSplit)) {
                idIndex = count;
            }
            ++count;
        }
        WindowsUtils.logMessage("User Index : " + userIndex);
        WindowsUtils.logMessage("Id Index : " + idIndex);
        if (userIndex >= 0 && idIndex >= 0) {
            for (int i = 1; i < rows.size(); ++i) {
                if (!rows.get(i).contains(username)) continue;
                String rowToSplit = rows.get(i).trim();
                WindowsUtils.logMessage("Processing Row for username:  " + rowToSplit);
                String[] rowSplit = rowToSplit.replace(">", "").split("\\s+");
                if (!username.equals(rowSplit[userIndex])) continue;
                WindowsUtils.logMessage("Returning Id of user : " + WindowsUtils.getUserIndex(rowSplit, idIndex));
                return WindowsUtils.getUserIndex(rowSplit, idIndex);
            }
        }
        WindowsUtils.logMessage("Returning -1 could not find user : " + username);
        return -1;
    }

    private static int getUserIndex(String[] columns, int userIndex) {
        String regex = "\\d+";
        int currentIndex = userIndex;
        int previousIndex = userIndex - 1;
        WindowsUtils.logMessage("userId in userIndex " + columns[userIndex]);
        WindowsUtils.logMessage("userId in userIndex -1 " + columns[previousIndex]);
        if (columns[currentIndex].matches(regex)) {
            WindowsUtils.logMessage("Returning currentIndex :: " + columns[currentIndex]);
            return Integer.parseInt(columns[currentIndex].trim());
        }
        if (columns[previousIndex].matches(regex)) {
            WindowsUtils.logMessage("Returning previousIndex :: " + columns[previousIndex]);
            return Integer.parseInt(columns[previousIndex].trim());
        }
        WindowsUtils.logMessage("Returning :: -1 since getUserIndex did not match");
        return -1;
    }

    public static File getTempDir() {
        return new File(System.getProperty("java.io.tmpdir"));
    }
}

