/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util.classmap;

import au.com.ordermate.persistence.DBMapping;
import au.com.ordermate.util.classmap.BusinessObjectDependency;
import java.util.HashMap;
import java.util.Map;

public class BusinessObject {
    private final String label;
    private String table;
    private String discriminatorColumn;
    private final String discriminator;
    private final Class clazz;
    private Map<Class, BusinessObjectDependency> dependencies;
    private Map<Class, BusinessObjectDependency> references;
    private BusinessObject superClazz;
    private DBMapping.Mapping mapping = DBMapping.Mapping.Columnar;

    BusinessObject(Class clazz, String yourTable, String discriminatorColumn, String discriminator) {
        this.clazz = clazz;
        this.label = clazz.getSimpleName();
        this.discriminatorColumn = discriminatorColumn;
        this.discriminator = discriminator;
        this.table = yourTable;
    }

    public String getLabel() {
        return this.label;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public String getTable() {
        return this.table;
    }

    public String getDiscriminatorColumn() {
        return this.discriminatorColumn;
    }

    public String getDiscriminator() {
        return this.discriminator;
    }

    void setSuperClazz(BusinessObject value) {
        this.superClazz = value;
    }

    public BusinessObject getSuperClazz() {
        return this.superClazz;
    }

    void addDependency(BusinessObject ref) {
        if (ref == null) {
            return;
        }
        if (this.dependencies == null) {
            this.dependencies = new HashMap<Class, BusinessObjectDependency>();
        }
        if (!this.dependencies.containsKey(ref.getClazz())) {
            this.dependencies.put(ref.getClazz(), new BusinessObjectDependency(this, ref));
        }
    }

    public Map<Class, BusinessObjectDependency> getDependencies() {
        return this.dependencies;
    }

    public Map<Class, BusinessObjectDependency> getReferences() {
        return this.references;
    }

    public DBMapping.Mapping getMapping() {
        return this.mapping;
    }

    void setMapping(DBMapping.Mapping yourMapping) {
        this.mapping = yourMapping == null ? DBMapping.Mapping.Columnar : yourMapping;
    }

    void lockItIn() {
        if (this.superClazz != null) {
            this.superClazz.lockItIn();
            Map<Class, BusinessObjectDependency> superDeps = this.superClazz.getDependencies();
            if (superDeps != null) {
                if (this.dependencies == null) {
                    this.dependencies = new HashMap<Class, BusinessObjectDependency>(superDeps);
                } else {
                    this.dependencies.putAll(this.superClazz.getDependencies());
                }
            }
            if (this.discriminatorColumn == null) {
                this.discriminatorColumn = this.superClazz.getDiscriminatorColumn();
            }
            if (this.table == null) {
                this.table = this.superClazz.getTable();
            }
        }
        if (this.dependencies != null) {
            for (BusinessObjectDependency dependency : this.dependencies.values()) {
                dependency.getDependee().addReference(dependency);
            }
        }
    }

    void lockInReferences() {
        if (this.superClazz != null) {
            this.superClazz.lockInReferences();
            Map<Class, BusinessObjectDependency> superRefs = this.superClazz.getReferences();
            if (superRefs != null) {
                if (this.references == null) {
                    this.references = new HashMap<Class, BusinessObjectDependency>();
                }
                this.references.putAll(superRefs);
            }
        }
    }

    void addDependency(BusinessObjectDependency newDep) {
        if (!this.dependencies.containsKey(newDep.getDependee().getClazz())) {
            this.dependencies.put(newDep.getDependee().getClazz(), newDep);
        } else {
            BusinessObjectDependency myDep = this.dependencies.get(newDep.getDependee().getClazz());
            if (newDep.isCyclic()) {
                myDep.setCyclic(true);
            }
            if (newDep.getProximity() < myDep.getProximity()) {
                myDep.setProximity(newDep.getProximity());
                myDep.setDependor(newDep.getDependor());
            }
        }
    }

    void addReference(BusinessObjectDependency newReference) {
        Class key;
        if (this.references == null) {
            this.references = new HashMap<Class, BusinessObjectDependency>();
        }
        if (this.references.containsKey(key = newReference.getDependor().getClazz())) {
            if (newReference.getProximity() < this.references.get(key).getProximity()) {
                this.references.put(newReference.getDependor().getClazz(), newReference);
            }
        } else {
            this.references.put(newReference.getDependor().getClazz(), newReference);
        }
    }

    public String toString() {
        return this.getLabel();
    }
}

