/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util.classmap;

import au.com.ordermate.persistence.DBMapping;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.util.classmap.BusinessObject;
import au.com.ordermate.util.classmap.BusinessObjectDependency;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import ordermate.OrderMate;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.TypeAnnotationsScanner;

public class ClassMapper {
    private Map<Class, BusinessObject> descriptionMap;
    private Set<Class> currentlyResolving;
    private Map<Class, BusinessObject> independents;
    private Map<String, BusinessObject> tableToBoMap = new ConcurrentHashMap<String, BusinessObject>();

    public void mapPath(String pathToExamine) {
        this.descriptionMap = new LinkedHashMap<Class, BusinessObject>();
        this.currentlyResolving = new HashSet<Class>();
        Reflections refs = new Reflections(pathToExamine, new Scanner[]{new TypeAnnotationsScanner()});
        HashSet<Class<PersistentObject>> classes = new HashSet<Class<PersistentObject>>();
        classes.add(PersistentObject.class);
        classes.addAll(refs.getTypesAnnotatedWith(MappedSuperclass.class));
        classes.addAll(refs.getTypesAnnotatedWith(Table.class));
        classes.addAll(refs.getTypesAnnotatedWith(Entity.class));
        classes.addAll(refs.getTypesAnnotatedWith(DiscriminatorValue.class));
        ArrayList orderedClasses = new ArrayList(classes);
        Collections.sort(orderedClasses, new Comparator<Class>(){

            @Override
            public int compare(Class o1, Class o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (Class clazz : orderedClasses) {
            this.mapClass(clazz);
        }
        this.assignSuperClasses();
        this.mapDirectDependencies();
        int passes = 2;
        for (int i = 0; i < passes; ++i) {
            this.mapDependencies();
        }
        this.formaliseReferences();
        this.currentlyResolving = null;
    }

    public Map<Class, BusinessObject> getMap() {
        return this.descriptionMap;
    }

    private void mapClass(Class clazz) {
        if (PersistentObject.class.isAssignableFrom(clazz)) {
            Table tableAnnotation = clazz.getAnnotation(Table.class);
            DiscriminatorColumn discColumn = clazz.getAnnotation(DiscriminatorColumn.class);
            DiscriminatorValue discValue = clazz.getAnnotation(DiscriminatorValue.class);
            BusinessObject newObject = new BusinessObject(clazz, tableAnnotation == null ? null : tableAnnotation.name(), discColumn == null ? null : discColumn.name(), discValue == null ? null : discValue.value());
            this.descriptionMap.put(clazz, newObject);
            DBMapping mapping = clazz.getAnnotation(DBMapping.class);
            if (mapping != null) {
                newObject.setMapping(mapping.value());
            }
        }
    }

    private void assignSuperClasses() {
        for (BusinessObject nextObject : this.descriptionMap.values()) {
            Class superClass = nextObject.getClazz().getSuperclass();
            while (!Object.class.equals(superClass) && !this.descriptionMap.containsKey(superClass)) {
                superClass = superClass.getSuperclass();
            }
            nextObject.setSuperClazz(this.descriptionMap.get(superClass));
        }
    }

    private void mapDirectDependencies() {
        for (Class clazz : this.descriptionMap.keySet()) {
            for (Method nextMethod : clazz.getMethods()) {
                BusinessObject bo;
                if (nextMethod.getAnnotation(ManyToOne.class) != null) {
                    bo = this.descriptionMap.get(nextMethod.getDeclaringClass());
                    bo.addDependency(this.descriptionMap.get(nextMethod.getReturnType()));
                    continue;
                }
                if (nextMethod.getAnnotation(OneToOne.class) == null || nextMethod.getAnnotation(JoinColumn.class) == null) continue;
                bo = this.descriptionMap.get(nextMethod.getDeclaringClass());
                bo.addDependency(this.descriptionMap.get(nextMethod.getReturnType()));
            }
        }
    }

    private void formaliseReferences() {
        for (BusinessObject bo : this.descriptionMap.values()) {
            bo.lockItIn();
        }
        for (BusinessObject bo : this.descriptionMap.values()) {
            bo.lockInReferences();
        }
        this.descriptionMap = Collections.unmodifiableMap(this.descriptionMap);
    }

    private void mapDependencies() {
        for (BusinessObject bo : this.descriptionMap.values()) {
            if (bo.getDependencies() == null) continue;
            LinkedHashMap<Class, BusinessObjectDependency> dependencies = new LinkedHashMap<Class, BusinessObjectDependency>(bo.getDependencies());
            for (BusinessObjectDependency dependency : bo.getDependencies().values()) {
                this.currentlyResolving.clear();
                this.addDependencies(dependency.getDependee(), dependencies, dependency.getProximity(), bo);
            }
            for (BusinessObjectDependency nextDependency : dependencies.values()) {
                bo.addDependency(nextDependency);
            }
        }
    }

    private void addDependencies(BusinessObject currentReference, Map<Class, BusinessObjectDependency> resolved, int currentProximity, BusinessObject baseBusinessObject) {
        int newProximity = currentProximity + 1;
        if (currentReference.getDependencies() != null) {
            for (BusinessObjectDependency ref : currentReference.getDependencies().values()) {
                BusinessObjectDependency dependency;
                BusinessObject dependee = ref.getDependee();
                if (this.currentlyResolving.contains(dependee.getClazz())) continue;
                this.currentlyResolving.add(currentReference.getClazz());
                if (resolved.containsKey(dependee.getClazz())) {
                    dependency = resolved.get(dependee.getClazz());
                    if (dependency.getProximity() > ref.getProximity() + newProximity) {
                        dependency.setProximity(ref.getProximity() + newProximity);
                        dependency.setDependor(ref.getDependor());
                    } else if (dependency.getProximity() == ref.getProximity() + newProximity && dependency.getDependor().getLabel().compareTo(ref.getDependor().getLabel()) > 0 && ref.getDependor().getLabel().compareTo(ref.getDependee().getLabel()) != 0) {
                        dependency.setDependor(ref.getDependor());
                    }
                } else {
                    dependency = new BusinessObjectDependency(ref.getDependor(), dependee);
                    if (ref.isCyclic()) {
                        dependency.setProximity(ref.getProximity() + newProximity + 1);
                    } else {
                        dependency.setProximity(ref.getProximity() + newProximity);
                    }
                    resolved.put(dependee.getClazz(), dependency);
                }
                if (!dependency.isCyclic() && dependee.getDependencies() != null && dependee.getDependencies().containsKey(baseBusinessObject.getClazz())) {
                    dependency.setCyclic(true);
                }
                this.addDependencies(dependee, resolved, newProximity, baseBusinessObject);
            }
        }
    }

    public Map<Class, BusinessObject> getIndependents() {
        if (this.descriptionMap == null) {
            throw new IllegalStateException("Call Map Path before getting Independents");
        }
        if (this.independents == null) {
            LinkedHashMap<Class, BusinessObject> newIndependents = new LinkedHashMap<Class, BusinessObject>();
            for (BusinessObject bo : this.descriptionMap.values()) {
                if (bo.getDependencies() == null || bo.getDependencies().isEmpty()) {
                    newIndependents.put(bo.getClazz(), bo);
                    continue;
                }
                if (bo.getDependencies().size() != 1 || !bo.getDependencies().values().iterator().next().isCyclic()) continue;
                newIndependents.put(bo.getClazz(), bo);
            }
            this.independents = Collections.unmodifiableMap(newIndependents);
        }
        return this.independents;
    }

    public BusinessObject getBusinessObjectForTableName(String tableName) {
        if (this.tableToBoMap.containsKey(tableName)) {
            return this.tableToBoMap.get(tableName);
        }
        for (BusinessObject bo : this.getMap().values()) {
            String boTable = bo.getTable();
            if (bo.getTable() == null || !boTable.equals(tableName)) continue;
            BusinessObject toAdd = bo;
            OrderMate.LOG.info("Found " + bo);
            while (toAdd.getSuperClazz() != null && !PersistentObject.class.equals((Object)toAdd.getSuperClazz().getClazz()) && toAdd.getSuperClazz().getTable() != null) {
                OrderMate.LOG.info("Superclass is " + toAdd.getSuperClazz());
                toAdd = toAdd.getSuperClazz();
            }
            OrderMate.LOG.info("Mapping table to class:" + toAdd.getTable() + " for " + toAdd.getClazz());
            this.tableToBoMap.put(toAdd.getTable(), toAdd);
            break;
        }
        return this.tableToBoMap.get(tableName);
    }
}

