/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util.classmap;

import au.com.ordermate.util.classmap.BusinessObject;
import au.com.ordermate.util.classmap.BusinessObjectDependency;
import au.com.ordermate.util.classmap.ClassMapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;

public class ClassTierMapper {
    private ClassMapper classMapper;
    private Map<Class, BusinessObject> independents;
    private Map<Class, Integer> classToTierMap = new HashMap<Class, Integer>();
    private Map<Integer, Set<Class>> tierToClassMap = new HashMap<Integer, Set<Class>>();
    private Reflections reflections;

    public ClassTierMapper(ClassMapper classMapper) {
        this.classMapper = classMapper;
        this.independents = classMapper.getIndependents();
        this.reflections = new Reflections("ordermate.database", new Scanner[]{new SubTypesScanner()});
        this.generateClassTiers();
    }

    private void generateClassTiers() {
        for (Map.Entry<Class, BusinessObject> entry : this.classMapper.getMap().entrySet()) {
            int tier = 0;
            if (entry.getValue().getDependencies() != null) {
                for (BusinessObjectDependency dependency : entry.getValue().getDependencies().values()) {
                    if (dependency.getProximity() + 1 <= tier) continue;
                    tier = dependency.getProximity() + 1;
                }
            }
            this.placeClass(entry.getKey(), tier);
        }
    }

    private void mapReference(BusinessObject bo, int proximity) {
        if (bo.getReferences() != null) {
            for (BusinessObjectDependency reference : bo.getReferences().values()) {
                if (reference.getProximity() != 0) continue;
                BusinessObject dependor = reference.getDependor();
                Set dependencyClasses = this.reflections.getSubTypesOf(dependor.getClazz());
                Iterator iterator = dependencyClasses.iterator();
                while (iterator.hasNext()) {
                    Class subclass = (Class)iterator.next();
                    if (this.classMapper.getMap().containsKey(subclass)) continue;
                    iterator.remove();
                }
                dependencyClasses.add(dependor.getClazz());
                for (Class dependencyClass : dependencyClasses) {
                    if (this.classToTierMap.containsKey(dependencyClass)) {
                        if (reference.getProximity() + proximity <= this.classToTierMap.get(dependencyClass) || reference.isCyclic()) continue;
                        this.tierToClassMap.get(this.classToTierMap.get(dependencyClass)).remove(dependencyClass);
                        this.placeClass(dependencyClass, reference.getProximity() + proximity);
                        continue;
                    }
                    if (this.independents.containsKey(dependencyClass)) continue;
                    this.placeClass(dependencyClass, reference.getProximity() + proximity);
                    this.mapReference(this.classMapper.getMap().get(dependencyClass), proximity + 1);
                }
            }
        }
    }

    private void placeClass(Class clazz, Integer tier) {
        this.classToTierMap.put(clazz, tier);
        if (!this.tierToClassMap.containsKey(tier)) {
            this.tierToClassMap.put(tier, new HashSet());
        }
        this.tierToClassMap.get(tier).add(clazz);
    }

    public Map<Class, Integer> getClassToTierMap() {
        return Collections.unmodifiableMap(this.classToTierMap);
    }

    public Map<Integer, Set<Class>> getTierToClassMap() {
        return Collections.unmodifiableMap(this.tierToClassMap);
    }
}

