/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util.connectivity;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.gui.GuiHandler;
import java.awt.Desktop;
import java.net.URI;
import ordermate.database.sales.Customer;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;

public class GoogleMapHelper {
    private static final String GOOGLE_MAPS_URL = "http://maps.google.com.au/maps";
    private static final GoogleMapHelper helper = new GoogleMapHelper();

    public static GoogleMapHelper getInstance() {
        return helper;
    }

    public void showGoogleMap(Customer customer, GuiHandler handler) {
        block4: {
            if (customer == null) {
                if (handler != null) {
                    handler.displayOkDialog("No Customer Set", "Cannot show an address without a customer.");
                }
                return;
            }
            GetMethod method = this.constructHttpRequest(customer.getAddress());
            try {
                String url = "http://maps.google.com.au/maps?" + method.getQueryString();
                OrderMateLog.LOG.info("Browsing :" + url);
                Desktop.getDesktop().browse(new URI(url));
            }
            catch (Exception ex) {
                OrderMateLog.LOG.info("Could not open google map", (Throwable)ex);
                if (handler == null) break block4;
                StringBuilder SB = new StringBuilder("<html>The map location cannot be shown.<br>").append("Please check your internet connection from this terminal.<br><br>").append("If this problem persists, please call Ordermate support.</html>");
                handler.displayOkDialog("Cannot Show Map", SB.toString());
            }
        }
    }

    private GetMethod constructHttpRequest(String addressComponents) {
        GetMethod method = new GetMethod();
        method.setQueryString(new NameValuePair[]{new NameValuePair("q", addressComponents), new NameValuePair("hl", "en")});
        return method;
    }
}

