/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util.connectivity;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.util.StringUtils;
import ordermate.database.misc.SystemProperty;
import twitter4j.Status;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.auth.AccessToken;

public class TwitterHelper {
    public static final int MAX_TWEET_LENGTH = 140;
    private static final String OAUTH_KEY = "gILbaLHCHQlotY3ro6aSsw";
    private static final String OAUTH_SECRET = "ucp7T7xzNch3cLGKzYsOwwqQNBv41IUQpym7AhsZPG0";
    static final String APPLICATION_NAME = "Ordermate Point of Sale";
    private TwitterFactory twitterFactory;

    public TwitterHelper() {
        System.setProperty("twitter4j.oauth.consumerKey", OAUTH_KEY);
        System.setProperty("twitter4j.oauth.consumerSecret", OAUTH_SECRET);
        System.setProperty("twitter4j.source", APPLICATION_NAME);
        this.twitterFactory = new TwitterFactory();
    }

    public void tweet(String msg) throws TwitterException {
        if (!this.isValidTweet(msg)) {
            throw new IllegalArgumentException("Message is too long, must not be longer than 140 characters: " + msg);
        }
        Twitter twitter = this.getTwitter();
        twitter.updateStatus(msg);
    }

    public boolean isValidTweet(String msg) {
        return msg != null && msg.length() < 140 && msg.length() > 0;
    }

    protected Twitter getTwitter() throws TwitterException {
        if (this.haveTokens()) {
            AccessToken accessToken = new AccessToken(this.getAccessToken(), this.getAccessSecretToken());
            return this.twitterFactory.getInstance(accessToken);
        }
        throw new TwitterException("Twitter authorisation details not supplied.");
    }

    public boolean haveTokens() {
        return !StringUtils.isEmpty(this.getUserName()) && !StringUtils.isEmpty(this.getAccessToken()) && !StringUtils.isEmpty(this.getAccessSecretToken());
    }

    public Status getStatus() {
        try {
            return this.getStatusUnsafe();
        }
        catch (TwitterException ex) {
            OrderMateLog.LOG.warn("Could not contact twitter", (Throwable)ex);
            return null;
        }
    }

    public Status getStatusUnsafe() throws TwitterException {
        return this.getTwitter().showUser(this.getUserName()).getStatus();
    }

    public String getUserName() {
        return SystemProperty.getInstance().getTwitterUserName();
    }

    private String getAccessToken() {
        return SystemProperty.getInstance().getTwitterAccessToken();
    }

    private String getAccessSecretToken() {
        return SystemProperty.getInstance().getTwitterAccessSecretToken();
    }

    public String[] generateAccessTokens(String username, String password) {
        String accessToken = null;
        String accessSecretToken = null;
        try {
            TwitterFactory.getSingleton().setOAuthAccessToken(null);
            AccessToken token = TwitterFactory.getSingleton().getOAuthAccessToken(username, password);
            accessToken = token.getToken();
            accessSecretToken = token.getTokenSecret();
        }
        catch (TwitterException e) {
            OrderMateLog.LOG.error("Error authenticating Twitter", (Throwable)e);
        }
        if (accessToken == null || accessSecretToken == null) {
            OrderMateLog.LOG.error("Twitter Credentials are wrong");
        } else {
            SystemProperty.getInstance().setTwitterAccessToken(accessToken);
            SystemProperty.getInstance().setTwitterAccessSecretToken(accessSecretToken);
        }
        return new String[]{accessToken, accessSecretToken};
    }

    public String[] generateAccessTokensAndWriteToSystemProperty(String username, String password) {
        String[] tokens = this.generateAccessTokens(username, password);
        if (tokens[0] != null && tokens[1] != null) {
            SystemProperty.getInstance().setTwitterAccessToken(tokens[0]);
            SystemProperty.getInstance().setTwitterAccessSecretToken(tokens[1]);
        }
        return tokens;
    }
}

