/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util.file;

import au.com.ordermate.util.ProcessUtil;
import au.com.ordermate.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.List;
import ordermate.OrderMate;

public class FileUtils {
    private FileUtils() {
    }

    public static File findProgramFileDirectory() {
        List<File> files = FileUtils.findFilesLike("C:\\", "Program");
        File theFile = null;
        for (File file : files) {
            if (!file.isDirectory() || !file.getPath().toLowerCase().contains("files")) continue;
            theFile = file;
        }
        return theFile;
    }

    public static File getOtherProgramFilesDirOn64BitSystem(File wrongDir) {
        if (!FileUtils.is64BitOperatingSystem() || wrongDir == null) {
            return null;
        }
        List<File> files = FileUtils.findFilesLike("C:\\", "Program Files");
        if (files.size() >= 1) {
            for (File aFile : files) {
                if (wrongDir.equals(aFile)) continue;
                return aFile;
            }
        }
        return wrongDir;
    }

    public static boolean is64BitOperatingSystem() {
        return !FileUtils.findFilesLike("C:\\", "Program Files (x86)").isEmpty();
    }

    public static List<File> findFilesLike(String baseDir, String prefix) {
        File file = new File(baseDir);
        ArrayList<File> files = new ArrayList<File>();
        for (String nextFile : file.list()) {
            if (!StringUtils.startsWithIgnoreCase(nextFile, prefix)) continue;
            files.add(new File(baseDir + File.separator + nextFile + File.separator));
        }
        return files;
    }

    public static String toPath(boolean isDir, String ... components) {
        StringBuilder SB = new StringBuilder();
        for (String component : components) {
            SB.append(component);
            SB.append(File.separator);
        }
        if (!isDir) {
            SB.replace(SB.length() - File.separator.length(), SB.length(), "");
        }
        return SB.toString();
    }

    public static String[] getRowsFromCSV(String fileName) throws IOException {
        String line;
        File inputFile = new File(fileName);
        FileReader fileReader = new FileReader(inputFile);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        ArrayList<String> rows = new ArrayList<String>();
        while ((line = bufferedReader.readLine()) != null) {
            rows.add(line);
        }
        fileReader.close();
        bufferedReader.close();
        return rows.toArray(new String[rows.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String source, String destination) throws IOException {
        OrderMate.LOG.info("Copying file from \"" + source + "\" to \"" + destination + "\".");
        File sourceFile = new File(source);
        if (!sourceFile.exists()) {
            OrderMate.LOG.warn("File does not exist:" + source);
            return;
        }
        File destinationFile = new File(destination);
        if (!destinationFile.getParentFile().exists()) {
            destinationFile.getParentFile().mkdirs();
        }
        if (!destinationFile.exists()) {
            destinationFile.createNewFile();
        }
        FileInputStream sourceStream = null;
        FileOutputStream destStream = null;
        try {
            sourceStream = new FileInputStream(sourceFile);
            destStream = new FileOutputStream(destinationFile);
            long l = destStream.getChannel().transferFrom(sourceStream.getChannel(), 0L, sourceStream.getChannel().size());
        }
        finally {
            if (sourceStream != null) {
                sourceStream.close();
            }
            if (destStream != null) {
                destStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFile(String fileUrl, String destination) throws IOException {
        URL url = new URL(fileUrl);
        ReadableByteChannel rbc = Channels.newChannel(url.openStream());
        try (FileOutputStream fileOut = null;){
            fileOut = new FileOutputStream(destination);
            fileOut.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
        }
    }

    public static long getFileLength(String filename) {
        File file = new File(filename);
        if (file.exists()) {
            return file.length();
        }
        return 0L;
    }

    public static boolean isOSLinux() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.contains("nux") || os.contains("nix") || os.contains("mac");
    }

    public static long fileSize(File fileOrDir) {
        if (!fileOrDir.isDirectory()) {
            return fileOrDir.length();
        }
        File[] files = fileOrDir.listFiles();
        if (files == null || files.length == 0) {
            return 0L;
        }
        long length = 0L;
        for (File file : fileOrDir.listFiles()) {
            if (file.isFile()) {
                length += file.length();
                continue;
            }
            length += FileUtils.fileSize(file);
        }
        return length;
    }

    public static File createShortcut(String location, String link, String arguments, String icon, String workDir) throws IOException {
        StringBuilder SB = new StringBuilder();
        SB.append("Set oWS = WScript.CreateObject(\"WScript.Shell\")\r\n");
        SB.append("sLinkFile = \"").append(location).append("\"\r\n");
        SB.append("Set oLink = oWS.CreateShortcut(sLinkFile)\r\n");
        SB.append("oLink.TargetPath = \"").append(link).append("\"\r\n");
        if (icon != null) {
            SB.append("oLink.IconLocation = \"").append(icon).append("\"\r\n");
        }
        if (arguments != null) {
            SB.append("oLink.Arguments = \"").append(arguments).append("\"\r\n");
        }
        if (workDir != null) {
            SB.append("oLink.WorkingDirectory = \"" + workDir + "\"\r\n");
        }
        SB.append("oLink.Save\r\n");
        File tempBatch = File.createTempFile("makeLink", ".vbs");
        StringUtils.writeTextToFile(tempBatch, SB.toString());
        ProcessUtil.runCmdAndWait("cscript.exe " + tempBatch.toString());
        tempBatch.delete();
        return new File(location);
    }

    public static String getTempDir() {
        return System.getProperty("java.io.tmpdir");
    }
}

