/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import ordermate.OrderMate;

public class FileZipper {
    private String relativePath;

    public static String getDefaultName(File toZip) {
        return toZip.getParent() + File.separator + toZip.getName() + ".zip";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unzipIt(String fileToUnzip, String locationToUnzip) {
        this.relativePath = locationToUnzip.endsWith(File.separator) ? locationToUnzip : locationToUnzip + File.separator;
        boolean allFine = true;
        File file = new File(fileToUnzip);
        if (!file.exists()) {
            throw new IllegalArgumentException("Cannot unzip a non existent file:" + fileToUnzip);
        }
        FileInputStream fin = null;
        ZipInputStream zin = null;
        try {
            fin = new FileInputStream(fileToUnzip);
            zin = new ZipInputStream(fin);
            ZipEntry entry = zin.getNextEntry();
            while (entry != null) {
                if (entry.isDirectory()) {
                    this.unzipDirectory(entry);
                } else {
                    this.unzipFile(entry, zin);
                }
                entry = zin.getNextEntry();
            }
        }
        catch (IOException ex) {
            OrderMate.LOG.error(ex.getMessage(), (Throwable)ex);
            allFine = false;
        }
        finally {
            if (fin != null) {
                try {
                    zin.close();
                    fin.close();
                }
                catch (IOException ex) {
                    OrderMate.LOG.error("Cannot close of zip and file input stream:", (Throwable)ex);
                }
            }
        }
        return allFine;
    }

    private void unzipDirectory(ZipEntry dirEntry) {
        File dir = new File(this.relativePath + dirEntry.getName());
        dir.mkdirs();
    }

    private void unzipFile(ZipEntry fileEntry, ZipInputStream zin) throws IOException {
        File file = new File(this.relativePath + fileEntry.getName());
        file.getParentFile().mkdirs();
        if (!file.exists()) {
            file.createNewFile();
        }
        byte[] data = new byte[4096];
        int length = 0;
        FileOutputStream fout = new FileOutputStream(file);
        while ((length = zin.read(data)) != -1) {
            fout.write(data, 0, length);
        }
        try {
            fout.flush();
            fout.close();
        }
        catch (IOException ex) {
            OrderMate.LOG.info("Cannot flush and close file output stream.", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zipIt(String fileToZip, String outputZipFile) {
        boolean fine = true;
        File input = new File(fileToZip);
        File output = new File(outputZipFile);
        if (!input.exists()) {
            OrderMate.LOG.error("Cannot zip directory that doesn't exist:" + input);
            return false;
        }
        this.relativePath = fileToZip.endsWith(File.separator) ? fileToZip.substring(0, fileToZip.indexOf(input.getName())) : fileToZip.substring(0, fileToZip.indexOf(input.getName())) + File.separator;
        FileOutputStream fout = null;
        DeflaterOutputStream zout = null;
        try {
            fout = new FileOutputStream(output);
            zout = new ZipOutputStream(fout);
            if (input.isDirectory()) {
                this.zipDirectory(input, (ZipOutputStream)zout);
            } else {
                this.zipFile(input, (ZipOutputStream)zout);
            }
        }
        catch (IOException ex) {
            OrderMate.LOG.error("Cannot zip contents:", (Throwable)ex);
            fine = false;
        }
        finally {
            if (fout != null && zout != null) {
                try {
                    zout.flush();
                    ((ZipOutputStream)zout).close();
                    fout.flush();
                    fout.close();
                }
                catch (IOException ex) {
                    OrderMate.LOG.error("Couldn't flush and close file:", (Throwable)ex);
                }
            }
        }
        return fine;
    }

    private void zipDirectory(File toZip, ZipOutputStream zout) throws IOException {
        String[] fileNames;
        for (String nextName : fileNames = toZip.list()) {
            File inputFile = new File(toZip.getPath() + File.separator + nextName);
            if (inputFile.isDirectory()) {
                this.zipDirectory(inputFile, zout);
                continue;
            }
            this.zipFile(inputFile, zout);
        }
    }

    private void zipFile(File toZip, ZipOutputStream zout) throws IOException {
        FileInputStream fin = new FileInputStream(toZip);
        String name = toZip.getPath().substring(this.relativePath.length() - 1);
        ZipEntry anEntry = new ZipEntry(name);
        byte[] readBuffer = new byte[4096];
        int readBytes = 0;
        zout.putNextEntry(anEntry);
        while ((readBytes = fin.read(readBuffer)) != -1) {
            zout.write(readBuffer, 0, readBytes);
        }
        fin.close();
    }
}

