/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.logging.log4j.core.Logger;

public class ZipIO {
    private Logger log;

    public ZipIO(Logger theLog) {
        this.log = theLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeOutToFile(File file, String data) throws FileNotFoundException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
            GZIPOutputStream gzout = new GZIPOutputStream(fout);
            gzout.write(data.length());
            gzout.write(data.getBytes());
            gzout.flush();
            gzout.close();
        }
        catch (IOException ex) {
            this.log.error("Couldn't write out to dongle export file:", (Throwable)ex);
        }
        finally {
            if (fout != null) {
                try {
                    fout.flush();
                    fout.close();
                }
                catch (IOException ex) {
                    this.log.error("Couldn't close off dongle export file:", (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readInFromFile(File file) throws FileNotFoundException {
        FileInputStream fin = null;
        String data = null;
        StringBuilder SB = new StringBuilder();
        try {
            this.log.info("Just want o try something out.");
            fin = new FileInputStream(file);
            GZIPInputStream gzin = new GZIPInputStream(fin);
            int length = gzin.read();
            for (int i = 0; i < length; ++i) {
                SB.append((char)gzin.read());
            }
            data = SB.toString();
        }
        catch (IOException ex) {
            this.log.error("Couldn't read in the Export file:", (Throwable)ex);
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (Exception ex) {
                    this.log.error("Couldn't close off the dongle file.");
                }
            }
        }
        return data;
    }
}

