/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util.finance.tax;

import au.com.ordermate.util.Price;
import au.com.ordermate.util.finance.tax.TaxAmount;
import au.com.ordermate.util.finance.tax.TaxCalculation;
import au.com.ordermate.util.finance.tax.TaxCodeI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;

class ComplexTaxCalculation
implements TaxCalculation {
    private TaxCodeI[][] groupedTaxCodes;
    private int numCodes;

    static boolean isApplicable(List<? extends TaxCodeI> codes) {
        return codes != null && codes.size() > 0;
    }

    ComplexTaxCalculation(List<? extends TaxCodeI> codes) {
        this.numCodes = codes.size();
        ArrayList<? extends TaxCodeI> sortedList = new ArrayList<TaxCodeI>(codes);
        Collections.sort(sortedList, new Comparator<TaxCodeI>(){

            @Override
            public int compare(TaxCodeI o1, TaxCodeI o2) {
                return Double.compare(o1.getSequence(), o2.getSequence());
            }
        });
        LinkedHashMap codeMap = new LinkedHashMap();
        for (TaxCodeI taxCodeI : codes) {
            Integer sequence = taxCodeI.getSequence();
            if (!codeMap.containsKey(sequence)) {
                codeMap.put(sequence, new ArrayList());
            }
            ((List)codeMap.get(sequence)).add(taxCodeI);
        }
        this.groupedTaxCodes = new TaxCodeI[codeMap.size()][];
        int index = 0;
        for (Integer key : codeMap.keySet()) {
            List theCodes = (List)codeMap.get(key);
            this.groupedTaxCodes[index] = theCodes.toArray(new TaxCodeI[theCodes.size()]);
            ++index;
        }
    }

    @Override
    public Price getUntaxedPrice(Price totalPrice) {
        double groupedBase = totalPrice.doubleValue();
        for (int group = this.groupedTaxCodes.length - 1; group >= 0; --group) {
            groupedBase /= 1.0 + this.sum(this.groupedTaxCodes[group]);
        }
        return new Price(groupedBase, 0.0);
    }

    @Override
    public Price getPriceIncTax(Price priceExTax) {
        double groupedBase = priceExTax.doubleValue();
        for (int group = this.groupedTaxCodes.length - 1; group >= 0; --group) {
            groupedBase *= 1.0 + this.sum(this.groupedTaxCodes[group]);
        }
        return new Price(groupedBase, 0.0);
    }

    @Override
    public Price getTotalTax(Price totalPrice) {
        return totalPrice.subtract(this.getUntaxedPrice(totalPrice));
    }

    @Override
    public List<TaxAmount> getTaxAmounts(Price totalPrice) {
        TaxAmount[] amounts = new TaxAmount[this.numCodes];
        int index = amounts.length - 1;
        double groupedBase = totalPrice.doubleValue();
        for (int group = this.groupedTaxCodes.length - 1; group >= 0; --group) {
            groupedBase /= 1.0 + this.sum(this.groupedTaxCodes[group]);
            for (int i = this.groupedTaxCodes[group].length - 1; i >= 0; --i) {
                double taxAmount = this.groupedTaxCodes[group][i].getRate() * groupedBase;
                amounts[index] = new TaxAmount(this.groupedTaxCodes[group][i], new Price(taxAmount, 0.0));
                --index;
            }
        }
        return Arrays.asList(amounts);
    }

    private double sum(TaxCodeI[] codes) {
        double totalRate = codes[0].getRate();
        if (codes.length > 1) {
            for (int i = 1; i < codes.length; ++i) {
                totalRate += codes[i].getRate();
            }
        }
        return totalRate;
    }

    public String toString() {
        return "ComplexTax:" + Arrays.toString((Object[])this.groupedTaxCodes);
    }

    @Override
    public Price getTaxFromExTaxPrice(Price extaxPrice) {
        return this.getPriceIncTax(extaxPrice).subtract(extaxPrice);
    }
}

